// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.clouddirectory.auth.CloudDirectoryAuthSchemeProvider
import aws.sdk.kotlin.services.clouddirectory.auth.DefaultCloudDirectoryAuthSchemeProvider
import aws.sdk.kotlin.services.clouddirectory.endpoints.CloudDirectoryEndpointParameters
import aws.sdk.kotlin.services.clouddirectory.endpoints.CloudDirectoryEndpointProvider
import aws.sdk.kotlin.services.clouddirectory.endpoints.DefaultCloudDirectoryEndpointProvider
import aws.sdk.kotlin.services.clouddirectory.model.AddFacetToObjectRequest
import aws.sdk.kotlin.services.clouddirectory.model.AddFacetToObjectResponse
import aws.sdk.kotlin.services.clouddirectory.model.ApplySchemaRequest
import aws.sdk.kotlin.services.clouddirectory.model.ApplySchemaResponse
import aws.sdk.kotlin.services.clouddirectory.model.AttachObjectRequest
import aws.sdk.kotlin.services.clouddirectory.model.AttachObjectResponse
import aws.sdk.kotlin.services.clouddirectory.model.AttachPolicyRequest
import aws.sdk.kotlin.services.clouddirectory.model.AttachPolicyResponse
import aws.sdk.kotlin.services.clouddirectory.model.AttachToIndexRequest
import aws.sdk.kotlin.services.clouddirectory.model.AttachToIndexResponse
import aws.sdk.kotlin.services.clouddirectory.model.AttachTypedLinkRequest
import aws.sdk.kotlin.services.clouddirectory.model.AttachTypedLinkResponse
import aws.sdk.kotlin.services.clouddirectory.model.BatchReadRequest
import aws.sdk.kotlin.services.clouddirectory.model.BatchReadResponse
import aws.sdk.kotlin.services.clouddirectory.model.BatchWriteRequest
import aws.sdk.kotlin.services.clouddirectory.model.BatchWriteResponse
import aws.sdk.kotlin.services.clouddirectory.model.CreateDirectoryRequest
import aws.sdk.kotlin.services.clouddirectory.model.CreateDirectoryResponse
import aws.sdk.kotlin.services.clouddirectory.model.CreateFacetRequest
import aws.sdk.kotlin.services.clouddirectory.model.CreateFacetResponse
import aws.sdk.kotlin.services.clouddirectory.model.CreateIndexRequest
import aws.sdk.kotlin.services.clouddirectory.model.CreateIndexResponse
import aws.sdk.kotlin.services.clouddirectory.model.CreateObjectRequest
import aws.sdk.kotlin.services.clouddirectory.model.CreateObjectResponse
import aws.sdk.kotlin.services.clouddirectory.model.CreateSchemaRequest
import aws.sdk.kotlin.services.clouddirectory.model.CreateSchemaResponse
import aws.sdk.kotlin.services.clouddirectory.model.CreateTypedLinkFacetRequest
import aws.sdk.kotlin.services.clouddirectory.model.CreateTypedLinkFacetResponse
import aws.sdk.kotlin.services.clouddirectory.model.DeleteDirectoryRequest
import aws.sdk.kotlin.services.clouddirectory.model.DeleteDirectoryResponse
import aws.sdk.kotlin.services.clouddirectory.model.DeleteFacetRequest
import aws.sdk.kotlin.services.clouddirectory.model.DeleteFacetResponse
import aws.sdk.kotlin.services.clouddirectory.model.DeleteObjectRequest
import aws.sdk.kotlin.services.clouddirectory.model.DeleteObjectResponse
import aws.sdk.kotlin.services.clouddirectory.model.DeleteSchemaRequest
import aws.sdk.kotlin.services.clouddirectory.model.DeleteSchemaResponse
import aws.sdk.kotlin.services.clouddirectory.model.DeleteTypedLinkFacetRequest
import aws.sdk.kotlin.services.clouddirectory.model.DeleteTypedLinkFacetResponse
import aws.sdk.kotlin.services.clouddirectory.model.DetachFromIndexRequest
import aws.sdk.kotlin.services.clouddirectory.model.DetachFromIndexResponse
import aws.sdk.kotlin.services.clouddirectory.model.DetachObjectRequest
import aws.sdk.kotlin.services.clouddirectory.model.DetachObjectResponse
import aws.sdk.kotlin.services.clouddirectory.model.DetachPolicyRequest
import aws.sdk.kotlin.services.clouddirectory.model.DetachPolicyResponse
import aws.sdk.kotlin.services.clouddirectory.model.DetachTypedLinkRequest
import aws.sdk.kotlin.services.clouddirectory.model.DetachTypedLinkResponse
import aws.sdk.kotlin.services.clouddirectory.model.DisableDirectoryRequest
import aws.sdk.kotlin.services.clouddirectory.model.DisableDirectoryResponse
import aws.sdk.kotlin.services.clouddirectory.model.EnableDirectoryRequest
import aws.sdk.kotlin.services.clouddirectory.model.EnableDirectoryResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetAppliedSchemaVersionRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetAppliedSchemaVersionResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetDirectoryRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetDirectoryResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetFacetRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetFacetResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetLinkAttributesRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetLinkAttributesResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetObjectAttributesRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetObjectAttributesResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetObjectInformationRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetObjectInformationResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetSchemaAsJsonRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetSchemaAsJsonResponse
import aws.sdk.kotlin.services.clouddirectory.model.GetTypedLinkFacetInformationRequest
import aws.sdk.kotlin.services.clouddirectory.model.GetTypedLinkFacetInformationResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListAppliedSchemaArnsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListAppliedSchemaArnsResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListAttachedIndicesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListAttachedIndicesResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListDirectoriesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListDirectoriesResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListFacetAttributesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListFacetAttributesResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListFacetNamesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListFacetNamesResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListIncomingTypedLinksRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListIncomingTypedLinksResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListIndexRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListIndexResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListManagedSchemaArnsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListManagedSchemaArnsResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectAttributesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectAttributesResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectChildrenRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectChildrenResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectParentPathsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectParentPathsResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectParentsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectParentsResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectPoliciesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectPoliciesResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListOutgoingTypedLinksRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListOutgoingTypedLinksResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListPolicyAttachmentsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListPolicyAttachmentsResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListPublishedSchemaArnsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListPublishedSchemaArnsResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse
import aws.sdk.kotlin.services.clouddirectory.model.ListTypedLinkFacetNamesRequest
import aws.sdk.kotlin.services.clouddirectory.model.ListTypedLinkFacetNamesResponse
import aws.sdk.kotlin.services.clouddirectory.model.LookupPolicyRequest
import aws.sdk.kotlin.services.clouddirectory.model.LookupPolicyResponse
import aws.sdk.kotlin.services.clouddirectory.model.PublishSchemaRequest
import aws.sdk.kotlin.services.clouddirectory.model.PublishSchemaResponse
import aws.sdk.kotlin.services.clouddirectory.model.PutSchemaFromJsonRequest
import aws.sdk.kotlin.services.clouddirectory.model.PutSchemaFromJsonResponse
import aws.sdk.kotlin.services.clouddirectory.model.RemoveFacetFromObjectRequest
import aws.sdk.kotlin.services.clouddirectory.model.RemoveFacetFromObjectResponse
import aws.sdk.kotlin.services.clouddirectory.model.TagResourceRequest
import aws.sdk.kotlin.services.clouddirectory.model.TagResourceResponse
import aws.sdk.kotlin.services.clouddirectory.model.UntagResourceRequest
import aws.sdk.kotlin.services.clouddirectory.model.UntagResourceResponse
import aws.sdk.kotlin.services.clouddirectory.model.UpdateFacetRequest
import aws.sdk.kotlin.services.clouddirectory.model.UpdateFacetResponse
import aws.sdk.kotlin.services.clouddirectory.model.UpdateLinkAttributesRequest
import aws.sdk.kotlin.services.clouddirectory.model.UpdateLinkAttributesResponse
import aws.sdk.kotlin.services.clouddirectory.model.UpdateObjectAttributesRequest
import aws.sdk.kotlin.services.clouddirectory.model.UpdateObjectAttributesResponse
import aws.sdk.kotlin.services.clouddirectory.model.UpdateSchemaRequest
import aws.sdk.kotlin.services.clouddirectory.model.UpdateSchemaResponse
import aws.sdk.kotlin.services.clouddirectory.model.UpdateTypedLinkFacetRequest
import aws.sdk.kotlin.services.clouddirectory.model.UpdateTypedLinkFacetResponse
import aws.sdk.kotlin.services.clouddirectory.model.UpgradeAppliedSchemaRequest
import aws.sdk.kotlin.services.clouddirectory.model.UpgradeAppliedSchemaResponse
import aws.sdk.kotlin.services.clouddirectory.model.UpgradePublishedSchemaRequest
import aws.sdk.kotlin.services.clouddirectory.model.UpgradePublishedSchemaResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CloudDirectory"
public const val SdkVersion: String = "1.3.112"
public const val ServiceApiVersion: String = "2017-01-11"

/**
 * # Amazon Cloud Directory
 * Amazon Cloud Directory is a component of the AWS Directory Service that simplifies the development and management of cloud-scale web, mobile, and IoT applications. This guide describes the Cloud Directory operations that you can call programmatically and includes detailed information on data types and errors. For information about Cloud Directory features, see [AWS Directory Service](https://aws.amazon.com/directoryservice/) and the [Amazon Cloud Directory Developer Guide](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/what_is_cloud_directory.html).
 */
public interface CloudDirectoryClient : SdkClient {
    /**
     * CloudDirectoryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CloudDirectoryClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CloudDirectory",
                "CLOUDDIRECTORY",
                "clouddirectory",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CloudDirectoryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CloudDirectoryClient = DefaultCloudDirectoryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CloudDirectoryEndpointProvider = builder.endpointProvider ?: DefaultCloudDirectoryEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CloudDirectoryAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCloudDirectoryAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CloudDirectory"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CloudDirectoryEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CloudDirectoryAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a new Facet to an object. An object can have more than one facet applied on it.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AddFacetToObject.sample
     */
    public suspend fun addFacetToObject(input: AddFacetToObjectRequest): AddFacetToObjectResponse

    /**
     * Copies the input published schema, at the specified version, into the Directory with the same name and version as that of the published schema.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ApplySchema.sample
     */
    public suspend fun applySchema(input: ApplySchemaRequest): ApplySchemaResponse

    /**
     * Attaches an existing object to another object. An object can be accessed in two ways:
     * + Using the path
     * + Using `ObjectIdentifier`
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachObject.sample
     */
    public suspend fun attachObject(input: AttachObjectRequest): AttachObjectResponse

    /**
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachPolicy.sample
     */
    public suspend fun attachPolicy(input: AttachPolicyRequest): AttachPolicyResponse

    /**
     * Attaches the specified object to the specified index.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachToIndex.sample
     */
    public suspend fun attachToIndex(input: AttachToIndexRequest): AttachToIndexResponse

    /**
     * Attaches a typed link to a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachTypedLink.sample
     */
    public suspend fun attachTypedLink(input: AttachTypedLinkRequest): AttachTypedLinkResponse

    /**
     * Performs all the read operations in a batch.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.BatchRead.sample
     */
    public suspend fun batchRead(input: BatchReadRequest): BatchReadResponse

    /**
     * Performs all the write operations in a batch. Either all the operations succeed or none.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.BatchWrite.sample
     */
    public suspend fun batchWrite(input: BatchWriteRequest): BatchWriteResponse

    /**
     * Creates a Directory by copying the published schema into the directory. A directory cannot be created without a schema.
     *
     * You can also quickly create a directory using a managed schema, called the `QuickStartSchema`. For more information, see [Managed Schema](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html) in the *Amazon Cloud Directory Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateDirectory.sample
     */
    public suspend fun createDirectory(input: CreateDirectoryRequest): CreateDirectoryResponse

    /**
     * Creates a new Facet in a schema. Facet creation is allowed only in development or applied schemas.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateFacet.sample
     */
    public suspend fun createFacet(input: CreateFacetRequest): CreateFacetResponse

    /**
     * Creates an index object. See [Indexing and search](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html) for more information.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateIndex.sample
     */
    public suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse

    /**
     * Creates an object in a Directory. Additionally attaches the object to a parent, if a parent reference and `LinkName` is specified. An object is simply a collection of Facet attributes. You can also use this API call to create a policy object, if the facet from which you create the object is a policy facet.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateObject.sample
     */
    public suspend fun createObject(input: CreateObjectRequest): CreateObjectResponse

    /**
     * Creates a new schema in a development state. A schema can exist in three phases:
     * + *Development:* This is a mutable phase of the schema. All new schemas are in the development phase. Once the schema is finalized, it can be published.
     * + *Published:* Published schemas are immutable and have a version associated with them.
     * + *Applied:* Applied schemas are mutable in a way that allows you to add new schema facets. You can also add new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateSchema.sample
     */
    public suspend fun createSchema(input: CreateSchemaRequest): CreateSchemaResponse

    /**
     * Creates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateTypedLinkFacet.sample
     */
    public suspend fun createTypedLinkFacet(input: CreateTypedLinkFacetRequest): CreateTypedLinkFacetResponse

    /**
     * Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme caution when deleting directories.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteDirectory.sample
     */
    public suspend fun deleteDirectory(input: DeleteDirectoryRequest): DeleteDirectoryResponse

    /**
     * Deletes a given Facet. All attributes and Rules that are associated with the facet will be deleted. Only development schema facets are allowed deletion.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteFacet.sample
     */
    public suspend fun deleteFacet(input: DeleteFacetRequest): DeleteFacetResponse

    /**
     * Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The maximum number of attributes that can be deleted during an object deletion is 30. For more information, see [Amazon Cloud Directory Limits](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteObject.sample
     */
    public suspend fun deleteObject(input: DeleteObjectRequest): DeleteObjectResponse

    /**
     * Deletes a given schema. Schemas in a development and published state can only be deleted.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteSchema.sample
     */
    public suspend fun deleteSchema(input: DeleteSchemaRequest): DeleteSchemaResponse

    /**
     * Deletes a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteTypedLinkFacet.sample
     */
    public suspend fun deleteTypedLinkFacet(input: DeleteTypedLinkFacetRequest): DeleteTypedLinkFacetResponse

    /**
     * Detaches the specified object from the specified index.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachFromIndex.sample
     */
    public suspend fun detachFromIndex(input: DetachFromIndexRequest): DetachFromIndexResponse

    /**
     * Detaches a given object from the parent object. The object that is to be detached from the parent is specified by the link name.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachObject.sample
     */
    public suspend fun detachObject(input: DetachObjectRequest): DetachObjectResponse

    /**
     * Detaches a policy from an object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachPolicy.sample
     */
    public suspend fun detachPolicy(input: DetachPolicyRequest): DetachPolicyResponse

    /**
     * Detaches a typed link from a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachTypedLink.sample
     */
    public suspend fun detachTypedLink(input: DetachTypedLinkRequest): DetachTypedLinkResponse

    /**
     * Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can be disabled. Disabled directories may be reenabled.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DisableDirectory.sample
     */
    public suspend fun disableDirectory(input: DisableDirectoryRequest): DisableDirectoryResponse

    /**
     * Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then be read and written to.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.EnableDirectory.sample
     */
    public suspend fun enableDirectory(input: EnableDirectoryRequest): EnableDirectoryResponse

    /**
     * Returns current applied schema version ARN, including the minor version in use.
     */
    public suspend fun getAppliedSchemaVersion(input: GetAppliedSchemaVersionRequest): GetAppliedSchemaVersionResponse

    /**
     * Retrieves metadata about a directory.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetDirectory.sample
     */
    public suspend fun getDirectory(input: GetDirectoryRequest): GetDirectoryResponse

    /**
     * Gets details of the Facet, such as facet name, attributes, Rules, or `ObjectType`. You can call this on all kinds of schema facets -- published, development, or applied.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetFacet.sample
     */
    public suspend fun getFacet(input: GetFacetRequest): GetFacetResponse

    /**
     * Retrieves attributes that are associated with a typed link.
     */
    public suspend fun getLinkAttributes(input: GetLinkAttributesRequest): GetLinkAttributesResponse

    /**
     * Retrieves attributes within a facet that are associated with an object.
     */
    public suspend fun getObjectAttributes(input: GetObjectAttributesRequest): GetObjectAttributesResponse

    /**
     * Retrieves metadata about an object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetObjectInformation.sample
     */
    public suspend fun getObjectInformation(input: GetObjectInformationRequest): GetObjectInformationResponse

    /**
     * Retrieves a JSON representation of the schema. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetSchemaAsJson.sample
     */
    public suspend fun getSchemaAsJson(input: GetSchemaAsJsonRequest): GetSchemaAsJsonResponse

    /**
     * Returns the identity attribute order for a specific TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetTypedLinkFacetInformation.sample
     */
    public suspend fun getTypedLinkFacetInformation(input: GetTypedLinkFacetInformationRequest): GetTypedLinkFacetInformationResponse

    /**
     * Lists schema major versions applied to a directory. If `SchemaArn` is provided, lists the minor version.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListAppliedSchemaArns.sample
     */
    public suspend fun listAppliedSchemaArns(input: ListAppliedSchemaArnsRequest): ListAppliedSchemaArnsResponse

    /**
     * Lists indices attached to the specified object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListAttachedIndices.sample
     */
    public suspend fun listAttachedIndices(input: ListAttachedIndicesRequest): ListAttachedIndicesResponse

    /**
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListDevelopmentSchemaArns.sample
     */
    public suspend fun listDevelopmentSchemaArns(input: ListDevelopmentSchemaArnsRequest = ListDevelopmentSchemaArnsRequest { }): ListDevelopmentSchemaArnsResponse

    /**
     * Lists directories created within an account.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListDirectories.sample
     */
    public suspend fun listDirectories(input: ListDirectoriesRequest = ListDirectoriesRequest { }): ListDirectoriesResponse

    /**
     * Retrieves attributes attached to the facet.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListFacetAttributes.sample
     */
    public suspend fun listFacetAttributes(input: ListFacetAttributesRequest): ListFacetAttributesResponse

    /**
     * Retrieves the names of facets that exist in a schema.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListFacetNames.sample
     */
    public suspend fun listFacetNames(input: ListFacetNamesRequest): ListFacetNamesResponse

    /**
     * Returns a paginated list of all the incoming TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListIncomingTypedLinks.sample
     */
    public suspend fun listIncomingTypedLinks(input: ListIncomingTypedLinksRequest): ListIncomingTypedLinksResponse

    /**
     * Lists objects attached to the specified index.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListIndex.sample
     */
    public suspend fun listIndex(input: ListIndexRequest): ListIndexResponse

    /**
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.
     */
    public suspend fun listManagedSchemaArns(input: ListManagedSchemaArnsRequest = ListManagedSchemaArnsRequest { }): ListManagedSchemaArnsResponse

    /**
     * Lists all attributes that are associated with an object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListObjectAttributes.sample
     */
    public suspend fun listObjectAttributes(input: ListObjectAttributesRequest): ListObjectAttributesResponse

    /**
     * Returns a paginated list of child objects that are associated with a given object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListObjectChildren.sample
     */
    public suspend fun listObjectChildren(input: ListObjectChildrenRequest): ListObjectChildrenResponse

    /**
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see [Directory Structure](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
     *
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory up to the requested object. The API returns the number of paths based on user-defined `MaxResults`, in case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored from the target object.
     */
    public suspend fun listObjectParentPaths(input: ListObjectParentPathsRequest): ListObjectParentPathsResponse

    /**
     * Lists parent objects that are associated with a given object in pagination fashion.
     */
    public suspend fun listObjectParents(input: ListObjectParentsRequest): ListObjectParentsResponse

    /**
     * Returns policies attached to an object in pagination fashion.
     */
    public suspend fun listObjectPolicies(input: ListObjectPoliciesRequest): ListObjectPoliciesResponse

    /**
     * Returns a paginated list of all the outgoing TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    public suspend fun listOutgoingTypedLinks(input: ListOutgoingTypedLinksRequest): ListOutgoingTypedLinksResponse

    /**
     * Returns all of the `ObjectIdentifiers` to which a given policy is attached.
     */
    public suspend fun listPolicyAttachments(input: ListPolicyAttachmentsRequest): ListPolicyAttachmentsResponse

    /**
     * Lists the major version families of each published schema. If a major version ARN is provided as `SchemaArn`, the minor version revisions in that family are listed instead.
     */
    public suspend fun listPublishedSchemaArns(input: ListPublishedSchemaArnsRequest = ListPublishedSchemaArnsRequest { }): ListPublishedSchemaArnsResponse

    /**
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per directory. All 50 tags are returned for a given directory with this API call.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a paginated list of all attribute definitions for a particular TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    public suspend fun listTypedLinkFacetAttributes(input: ListTypedLinkFacetAttributesRequest): ListTypedLinkFacetAttributesResponse

    /**
     * Returns a paginated list of `TypedLink` facet names for a particular schema. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    public suspend fun listTypedLinkFacetNames(input: ListTypedLinkFacetNamesRequest): ListTypedLinkFacetNamesResponse

    /**
     * Lists all policies from the root of the Directory to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the `ObjectIdentifier` for such objects. If policies are present, it returns `ObjectIdentifier`, `policyId`, and `policyType`. Paths that don't lead to the root from the target object are ignored. For more information, see [Policies](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
     */
    public suspend fun lookupPolicy(input: LookupPolicyRequest): LookupPolicyResponse

    /**
     * Publishes a development schema with a major version and a recommended minor version.
     */
    public suspend fun publishSchema(input: PublishSchemaRequest): PublishSchemaResponse

    /**
     * Allows a schema to be updated using JSON upload. Only available for development schemas. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
     */
    public suspend fun putSchemaFromJson(input: PutSchemaFromJsonRequest): PutSchemaFromJsonResponse

    /**
     * Removes the specified facet from the specified object.
     */
    public suspend fun removeFacetFromObject(input: RemoveFacetFromObjectRequest): RemoveFacetFromObjectResponse

    /**
     * An API operation for adding tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * An API operation for removing tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Does the following:
     * + Adds new `Attributes`, `Rules`, or `ObjectTypes`.
     * + Updates existing `Attributes`, `Rules`, or `ObjectTypes`.
     * + Deletes existing `Attributes`, `Rules`, or `ObjectTypes`.
     */
    public suspend fun updateFacet(input: UpdateFacetRequest): UpdateFacetResponse

    /**
     * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its `IdentityAttributeOrder`.
     */
    public suspend fun updateLinkAttributes(input: UpdateLinkAttributesRequest): UpdateLinkAttributesResponse

    /**
     * Updates a given object's attributes.
     */
    public suspend fun updateObjectAttributes(input: UpdateObjectAttributesRequest): UpdateObjectAttributesResponse

    /**
     * Updates the schema name with a new name. Only development schema names can be updated.
     */
    public suspend fun updateSchema(input: UpdateSchemaRequest): UpdateSchemaResponse

    /**
     * Updates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    public suspend fun updateTypedLinkFacet(input: UpdateTypedLinkFacetRequest): UpdateTypedLinkFacetResponse

    /**
     * Upgrades a single directory in-place using the `PublishedSchemaArn` with schema updates found in `MinorVersion`. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.
     */
    public suspend fun upgradeAppliedSchema(input: UpgradeAppliedSchemaRequest): UpgradeAppliedSchemaResponse

    /**
     * Upgrades a published schema under a new minor version revision using the current contents of `DevelopmentSchemaArn`.
     */
    public suspend fun upgradePublishedSchema(input: UpgradePublishedSchemaRequest): UpgradePublishedSchemaResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CloudDirectoryClient.withConfig(block: CloudDirectoryClient.Config.Builder.() -> Unit): CloudDirectoryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCloudDirectoryClient(newConfig)
}

/**
 * Adds a new Facet to an object. An object can have more than one facet applied on it.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.AddFacetToObject.sample
 */
public suspend inline fun CloudDirectoryClient.addFacetToObject(crossinline block: AddFacetToObjectRequest.Builder.() -> Unit): AddFacetToObjectResponse = addFacetToObject(AddFacetToObjectRequest.Builder().apply(block).build())

/**
 * Copies the input published schema, at the specified version, into the Directory with the same name and version as that of the published schema.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ApplySchema.sample
 */
public suspend inline fun CloudDirectoryClient.applySchema(crossinline block: ApplySchemaRequest.Builder.() -> Unit): ApplySchemaResponse = applySchema(ApplySchemaRequest.Builder().apply(block).build())

/**
 * Attaches an existing object to another object. An object can be accessed in two ways:
 * + Using the path
 * + Using `ObjectIdentifier`
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachObject.sample
 */
public suspend inline fun CloudDirectoryClient.attachObject(crossinline block: AttachObjectRequest.Builder.() -> Unit): AttachObjectResponse = attachObject(AttachObjectRequest.Builder().apply(block).build())

/**
 * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachPolicy.sample
 */
public suspend inline fun CloudDirectoryClient.attachPolicy(crossinline block: AttachPolicyRequest.Builder.() -> Unit): AttachPolicyResponse = attachPolicy(AttachPolicyRequest.Builder().apply(block).build())

/**
 * Attaches the specified object to the specified index.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachToIndex.sample
 */
public suspend inline fun CloudDirectoryClient.attachToIndex(crossinline block: AttachToIndexRequest.Builder.() -> Unit): AttachToIndexResponse = attachToIndex(AttachToIndexRequest.Builder().apply(block).build())

/**
 * Attaches a typed link to a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachTypedLink.sample
 */
public suspend inline fun CloudDirectoryClient.attachTypedLink(crossinline block: AttachTypedLinkRequest.Builder.() -> Unit): AttachTypedLinkResponse = attachTypedLink(AttachTypedLinkRequest.Builder().apply(block).build())

/**
 * Performs all the read operations in a batch.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.BatchRead.sample
 */
public suspend inline fun CloudDirectoryClient.batchRead(crossinline block: BatchReadRequest.Builder.() -> Unit): BatchReadResponse = batchRead(BatchReadRequest.Builder().apply(block).build())

/**
 * Performs all the write operations in a batch. Either all the operations succeed or none.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.BatchWrite.sample
 */
public suspend inline fun CloudDirectoryClient.batchWrite(crossinline block: BatchWriteRequest.Builder.() -> Unit): BatchWriteResponse = batchWrite(BatchWriteRequest.Builder().apply(block).build())

/**
 * Creates a Directory by copying the published schema into the directory. A directory cannot be created without a schema.
 *
 * You can also quickly create a directory using a managed schema, called the `QuickStartSchema`. For more information, see [Managed Schema](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html) in the *Amazon Cloud Directory Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateDirectory.sample
 */
public suspend inline fun CloudDirectoryClient.createDirectory(crossinline block: CreateDirectoryRequest.Builder.() -> Unit): CreateDirectoryResponse = createDirectory(CreateDirectoryRequest.Builder().apply(block).build())

/**
 * Creates a new Facet in a schema. Facet creation is allowed only in development or applied schemas.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateFacet.sample
 */
public suspend inline fun CloudDirectoryClient.createFacet(crossinline block: CreateFacetRequest.Builder.() -> Unit): CreateFacetResponse = createFacet(CreateFacetRequest.Builder().apply(block).build())

/**
 * Creates an index object. See [Indexing and search](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html) for more information.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateIndex.sample
 */
public suspend inline fun CloudDirectoryClient.createIndex(crossinline block: CreateIndexRequest.Builder.() -> Unit): CreateIndexResponse = createIndex(CreateIndexRequest.Builder().apply(block).build())

/**
 * Creates an object in a Directory. Additionally attaches the object to a parent, if a parent reference and `LinkName` is specified. An object is simply a collection of Facet attributes. You can also use this API call to create a policy object, if the facet from which you create the object is a policy facet.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateObject.sample
 */
public suspend inline fun CloudDirectoryClient.createObject(crossinline block: CreateObjectRequest.Builder.() -> Unit): CreateObjectResponse = createObject(CreateObjectRequest.Builder().apply(block).build())

/**
 * Creates a new schema in a development state. A schema can exist in three phases:
 * + *Development:* This is a mutable phase of the schema. All new schemas are in the development phase. Once the schema is finalized, it can be published.
 * + *Published:* Published schemas are immutable and have a version associated with them.
 * + *Applied:* Applied schemas are mutable in a way that allows you to add new schema facets. You can also add new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateSchema.sample
 */
public suspend inline fun CloudDirectoryClient.createSchema(crossinline block: CreateSchemaRequest.Builder.() -> Unit): CreateSchemaResponse = createSchema(CreateSchemaRequest.Builder().apply(block).build())

/**
 * Creates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateTypedLinkFacet.sample
 */
public suspend inline fun CloudDirectoryClient.createTypedLinkFacet(crossinline block: CreateTypedLinkFacetRequest.Builder.() -> Unit): CreateTypedLinkFacetResponse = createTypedLinkFacet(CreateTypedLinkFacetRequest.Builder().apply(block).build())

/**
 * Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme caution when deleting directories.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteDirectory.sample
 */
public suspend inline fun CloudDirectoryClient.deleteDirectory(crossinline block: DeleteDirectoryRequest.Builder.() -> Unit): DeleteDirectoryResponse = deleteDirectory(DeleteDirectoryRequest.Builder().apply(block).build())

/**
 * Deletes a given Facet. All attributes and Rules that are associated with the facet will be deleted. Only development schema facets are allowed deletion.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteFacet.sample
 */
public suspend inline fun CloudDirectoryClient.deleteFacet(crossinline block: DeleteFacetRequest.Builder.() -> Unit): DeleteFacetResponse = deleteFacet(DeleteFacetRequest.Builder().apply(block).build())

/**
 * Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The maximum number of attributes that can be deleted during an object deletion is 30. For more information, see [Amazon Cloud Directory Limits](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteObject.sample
 */
public suspend inline fun CloudDirectoryClient.deleteObject(crossinline block: DeleteObjectRequest.Builder.() -> Unit): DeleteObjectResponse = deleteObject(DeleteObjectRequest.Builder().apply(block).build())

/**
 * Deletes a given schema. Schemas in a development and published state can only be deleted.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteSchema.sample
 */
public suspend inline fun CloudDirectoryClient.deleteSchema(crossinline block: DeleteSchemaRequest.Builder.() -> Unit): DeleteSchemaResponse = deleteSchema(DeleteSchemaRequest.Builder().apply(block).build())

/**
 * Deletes a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteTypedLinkFacet.sample
 */
public suspend inline fun CloudDirectoryClient.deleteTypedLinkFacet(crossinline block: DeleteTypedLinkFacetRequest.Builder.() -> Unit): DeleteTypedLinkFacetResponse = deleteTypedLinkFacet(DeleteTypedLinkFacetRequest.Builder().apply(block).build())

/**
 * Detaches the specified object from the specified index.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachFromIndex.sample
 */
public suspend inline fun CloudDirectoryClient.detachFromIndex(crossinline block: DetachFromIndexRequest.Builder.() -> Unit): DetachFromIndexResponse = detachFromIndex(DetachFromIndexRequest.Builder().apply(block).build())

/**
 * Detaches a given object from the parent object. The object that is to be detached from the parent is specified by the link name.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachObject.sample
 */
public suspend inline fun CloudDirectoryClient.detachObject(crossinline block: DetachObjectRequest.Builder.() -> Unit): DetachObjectResponse = detachObject(DetachObjectRequest.Builder().apply(block).build())

/**
 * Detaches a policy from an object.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachPolicy.sample
 */
public suspend inline fun CloudDirectoryClient.detachPolicy(crossinline block: DetachPolicyRequest.Builder.() -> Unit): DetachPolicyResponse = detachPolicy(DetachPolicyRequest.Builder().apply(block).build())

/**
 * Detaches a typed link from a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachTypedLink.sample
 */
public suspend inline fun CloudDirectoryClient.detachTypedLink(crossinline block: DetachTypedLinkRequest.Builder.() -> Unit): DetachTypedLinkResponse = detachTypedLink(DetachTypedLinkRequest.Builder().apply(block).build())

/**
 * Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can be disabled. Disabled directories may be reenabled.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.DisableDirectory.sample
 */
public suspend inline fun CloudDirectoryClient.disableDirectory(crossinline block: DisableDirectoryRequest.Builder.() -> Unit): DisableDirectoryResponse = disableDirectory(DisableDirectoryRequest.Builder().apply(block).build())

/**
 * Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then be read and written to.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.EnableDirectory.sample
 */
public suspend inline fun CloudDirectoryClient.enableDirectory(crossinline block: EnableDirectoryRequest.Builder.() -> Unit): EnableDirectoryResponse = enableDirectory(EnableDirectoryRequest.Builder().apply(block).build())

/**
 * Returns current applied schema version ARN, including the minor version in use.
 */
public suspend inline fun CloudDirectoryClient.getAppliedSchemaVersion(crossinline block: GetAppliedSchemaVersionRequest.Builder.() -> Unit): GetAppliedSchemaVersionResponse = getAppliedSchemaVersion(GetAppliedSchemaVersionRequest.Builder().apply(block).build())

/**
 * Retrieves metadata about a directory.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetDirectory.sample
 */
public suspend inline fun CloudDirectoryClient.getDirectory(crossinline block: GetDirectoryRequest.Builder.() -> Unit): GetDirectoryResponse = getDirectory(GetDirectoryRequest.Builder().apply(block).build())

/**
 * Gets details of the Facet, such as facet name, attributes, Rules, or `ObjectType`. You can call this on all kinds of schema facets -- published, development, or applied.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetFacet.sample
 */
public suspend inline fun CloudDirectoryClient.getFacet(crossinline block: GetFacetRequest.Builder.() -> Unit): GetFacetResponse = getFacet(GetFacetRequest.Builder().apply(block).build())

/**
 * Retrieves attributes that are associated with a typed link.
 */
public suspend inline fun CloudDirectoryClient.getLinkAttributes(crossinline block: GetLinkAttributesRequest.Builder.() -> Unit): GetLinkAttributesResponse = getLinkAttributes(GetLinkAttributesRequest.Builder().apply(block).build())

/**
 * Retrieves attributes within a facet that are associated with an object.
 */
public suspend inline fun CloudDirectoryClient.getObjectAttributes(crossinline block: GetObjectAttributesRequest.Builder.() -> Unit): GetObjectAttributesResponse = getObjectAttributes(GetObjectAttributesRequest.Builder().apply(block).build())

/**
 * Retrieves metadata about an object.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetObjectInformation.sample
 */
public suspend inline fun CloudDirectoryClient.getObjectInformation(crossinline block: GetObjectInformationRequest.Builder.() -> Unit): GetObjectInformationResponse = getObjectInformation(GetObjectInformationRequest.Builder().apply(block).build())

/**
 * Retrieves a JSON representation of the schema. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetSchemaAsJson.sample
 */
public suspend inline fun CloudDirectoryClient.getSchemaAsJson(crossinline block: GetSchemaAsJsonRequest.Builder.() -> Unit): GetSchemaAsJsonResponse = getSchemaAsJson(GetSchemaAsJsonRequest.Builder().apply(block).build())

/**
 * Returns the identity attribute order for a specific TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetTypedLinkFacetInformation.sample
 */
public suspend inline fun CloudDirectoryClient.getTypedLinkFacetInformation(crossinline block: GetTypedLinkFacetInformationRequest.Builder.() -> Unit): GetTypedLinkFacetInformationResponse = getTypedLinkFacetInformation(GetTypedLinkFacetInformationRequest.Builder().apply(block).build())

/**
 * Lists schema major versions applied to a directory. If `SchemaArn` is provided, lists the minor version.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListAppliedSchemaArns.sample
 */
public suspend inline fun CloudDirectoryClient.listAppliedSchemaArns(crossinline block: ListAppliedSchemaArnsRequest.Builder.() -> Unit): ListAppliedSchemaArnsResponse = listAppliedSchemaArns(ListAppliedSchemaArnsRequest.Builder().apply(block).build())

/**
 * Lists indices attached to the specified object.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListAttachedIndices.sample
 */
public suspend inline fun CloudDirectoryClient.listAttachedIndices(crossinline block: ListAttachedIndicesRequest.Builder.() -> Unit): ListAttachedIndicesResponse = listAttachedIndices(ListAttachedIndicesRequest.Builder().apply(block).build())

/**
 * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListDevelopmentSchemaArns.sample
 */
public suspend inline fun CloudDirectoryClient.listDevelopmentSchemaArns(crossinline block: ListDevelopmentSchemaArnsRequest.Builder.() -> Unit): ListDevelopmentSchemaArnsResponse = listDevelopmentSchemaArns(ListDevelopmentSchemaArnsRequest.Builder().apply(block).build())

/**
 * Lists directories created within an account.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListDirectories.sample
 */
public suspend inline fun CloudDirectoryClient.listDirectories(crossinline block: ListDirectoriesRequest.Builder.() -> Unit): ListDirectoriesResponse = listDirectories(ListDirectoriesRequest.Builder().apply(block).build())

/**
 * Retrieves attributes attached to the facet.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListFacetAttributes.sample
 */
public suspend inline fun CloudDirectoryClient.listFacetAttributes(crossinline block: ListFacetAttributesRequest.Builder.() -> Unit): ListFacetAttributesResponse = listFacetAttributes(ListFacetAttributesRequest.Builder().apply(block).build())

/**
 * Retrieves the names of facets that exist in a schema.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListFacetNames.sample
 */
public suspend inline fun CloudDirectoryClient.listFacetNames(crossinline block: ListFacetNamesRequest.Builder.() -> Unit): ListFacetNamesResponse = listFacetNames(ListFacetNamesRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of all the incoming TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListIncomingTypedLinks.sample
 */
public suspend inline fun CloudDirectoryClient.listIncomingTypedLinks(crossinline block: ListIncomingTypedLinksRequest.Builder.() -> Unit): ListIncomingTypedLinksResponse = listIncomingTypedLinks(ListIncomingTypedLinksRequest.Builder().apply(block).build())

/**
 * Lists objects attached to the specified index.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListIndex.sample
 */
public suspend inline fun CloudDirectoryClient.listIndex(crossinline block: ListIndexRequest.Builder.() -> Unit): ListIndexResponse = listIndex(ListIndexRequest.Builder().apply(block).build())

/**
 * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.
 */
public suspend inline fun CloudDirectoryClient.listManagedSchemaArns(crossinline block: ListManagedSchemaArnsRequest.Builder.() -> Unit): ListManagedSchemaArnsResponse = listManagedSchemaArns(ListManagedSchemaArnsRequest.Builder().apply(block).build())

/**
 * Lists all attributes that are associated with an object.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListObjectAttributes.sample
 */
public suspend inline fun CloudDirectoryClient.listObjectAttributes(crossinline block: ListObjectAttributesRequest.Builder.() -> Unit): ListObjectAttributesResponse = listObjectAttributes(ListObjectAttributesRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of child objects that are associated with a given object.
 *
 * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListObjectChildren.sample
 */
public suspend inline fun CloudDirectoryClient.listObjectChildren(crossinline block: ListObjectChildrenRequest.Builder.() -> Unit): ListObjectChildrenResponse = listObjectChildren(ListObjectChildrenRequest.Builder().apply(block).build())

/**
 * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see [Directory Structure](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
 *
 * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory up to the requested object. The API returns the number of paths based on user-defined `MaxResults`, in case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored from the target object.
 */
public suspend inline fun CloudDirectoryClient.listObjectParentPaths(crossinline block: ListObjectParentPathsRequest.Builder.() -> Unit): ListObjectParentPathsResponse = listObjectParentPaths(ListObjectParentPathsRequest.Builder().apply(block).build())

/**
 * Lists parent objects that are associated with a given object in pagination fashion.
 */
public suspend inline fun CloudDirectoryClient.listObjectParents(crossinline block: ListObjectParentsRequest.Builder.() -> Unit): ListObjectParentsResponse = listObjectParents(ListObjectParentsRequest.Builder().apply(block).build())

/**
 * Returns policies attached to an object in pagination fashion.
 */
public suspend inline fun CloudDirectoryClient.listObjectPolicies(crossinline block: ListObjectPoliciesRequest.Builder.() -> Unit): ListObjectPoliciesResponse = listObjectPolicies(ListObjectPoliciesRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of all the outgoing TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 */
public suspend inline fun CloudDirectoryClient.listOutgoingTypedLinks(crossinline block: ListOutgoingTypedLinksRequest.Builder.() -> Unit): ListOutgoingTypedLinksResponse = listOutgoingTypedLinks(ListOutgoingTypedLinksRequest.Builder().apply(block).build())

/**
 * Returns all of the `ObjectIdentifiers` to which a given policy is attached.
 */
public suspend inline fun CloudDirectoryClient.listPolicyAttachments(crossinline block: ListPolicyAttachmentsRequest.Builder.() -> Unit): ListPolicyAttachmentsResponse = listPolicyAttachments(ListPolicyAttachmentsRequest.Builder().apply(block).build())

/**
 * Lists the major version families of each published schema. If a major version ARN is provided as `SchemaArn`, the minor version revisions in that family are listed instead.
 */
public suspend inline fun CloudDirectoryClient.listPublishedSchemaArns(crossinline block: ListPublishedSchemaArnsRequest.Builder.() -> Unit): ListPublishedSchemaArnsResponse = listPublishedSchemaArns(ListPublishedSchemaArnsRequest.Builder().apply(block).build())

/**
 * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per directory. All 50 tags are returned for a given directory with this API call.
 */
public suspend inline fun CloudDirectoryClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of all attribute definitions for a particular TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 */
public suspend inline fun CloudDirectoryClient.listTypedLinkFacetAttributes(crossinline block: ListTypedLinkFacetAttributesRequest.Builder.() -> Unit): ListTypedLinkFacetAttributesResponse = listTypedLinkFacetAttributes(ListTypedLinkFacetAttributesRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of `TypedLink` facet names for a particular schema. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 */
public suspend inline fun CloudDirectoryClient.listTypedLinkFacetNames(crossinline block: ListTypedLinkFacetNamesRequest.Builder.() -> Unit): ListTypedLinkFacetNamesResponse = listTypedLinkFacetNames(ListTypedLinkFacetNamesRequest.Builder().apply(block).build())

/**
 * Lists all policies from the root of the Directory to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the `ObjectIdentifier` for such objects. If policies are present, it returns `ObjectIdentifier`, `policyId`, and `policyType`. Paths that don't lead to the root from the target object are ignored. For more information, see [Policies](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
 */
public suspend inline fun CloudDirectoryClient.lookupPolicy(crossinline block: LookupPolicyRequest.Builder.() -> Unit): LookupPolicyResponse = lookupPolicy(LookupPolicyRequest.Builder().apply(block).build())

/**
 * Publishes a development schema with a major version and a recommended minor version.
 */
public suspend inline fun CloudDirectoryClient.publishSchema(crossinline block: PublishSchemaRequest.Builder.() -> Unit): PublishSchemaResponse = publishSchema(PublishSchemaRequest.Builder().apply(block).build())

/**
 * Allows a schema to be updated using JSON upload. Only available for development schemas. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
 */
public suspend inline fun CloudDirectoryClient.putSchemaFromJson(crossinline block: PutSchemaFromJsonRequest.Builder.() -> Unit): PutSchemaFromJsonResponse = putSchemaFromJson(PutSchemaFromJsonRequest.Builder().apply(block).build())

/**
 * Removes the specified facet from the specified object.
 */
public suspend inline fun CloudDirectoryClient.removeFacetFromObject(crossinline block: RemoveFacetFromObjectRequest.Builder.() -> Unit): RemoveFacetFromObjectResponse = removeFacetFromObject(RemoveFacetFromObjectRequest.Builder().apply(block).build())

/**
 * An API operation for adding tags to a resource.
 */
public suspend inline fun CloudDirectoryClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * An API operation for removing tags from a resource.
 */
public suspend inline fun CloudDirectoryClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Does the following:
 * + Adds new `Attributes`, `Rules`, or `ObjectTypes`.
 * + Updates existing `Attributes`, `Rules`, or `ObjectTypes`.
 * + Deletes existing `Attributes`, `Rules`, or `ObjectTypes`.
 */
public suspend inline fun CloudDirectoryClient.updateFacet(crossinline block: UpdateFacetRequest.Builder.() -> Unit): UpdateFacetResponse = updateFacet(UpdateFacetRequest.Builder().apply(block).build())

/**
 * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its `IdentityAttributeOrder`.
 */
public suspend inline fun CloudDirectoryClient.updateLinkAttributes(crossinline block: UpdateLinkAttributesRequest.Builder.() -> Unit): UpdateLinkAttributesResponse = updateLinkAttributes(UpdateLinkAttributesRequest.Builder().apply(block).build())

/**
 * Updates a given object's attributes.
 */
public suspend inline fun CloudDirectoryClient.updateObjectAttributes(crossinline block: UpdateObjectAttributesRequest.Builder.() -> Unit): UpdateObjectAttributesResponse = updateObjectAttributes(UpdateObjectAttributesRequest.Builder().apply(block).build())

/**
 * Updates the schema name with a new name. Only development schema names can be updated.
 */
public suspend inline fun CloudDirectoryClient.updateSchema(crossinline block: UpdateSchemaRequest.Builder.() -> Unit): UpdateSchemaResponse = updateSchema(UpdateSchemaRequest.Builder().apply(block).build())

/**
 * Updates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
 */
public suspend inline fun CloudDirectoryClient.updateTypedLinkFacet(crossinline block: UpdateTypedLinkFacetRequest.Builder.() -> Unit): UpdateTypedLinkFacetResponse = updateTypedLinkFacet(UpdateTypedLinkFacetRequest.Builder().apply(block).build())

/**
 * Upgrades a single directory in-place using the `PublishedSchemaArn` with schema updates found in `MinorVersion`. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.
 */
public suspend inline fun CloudDirectoryClient.upgradeAppliedSchema(crossinline block: UpgradeAppliedSchemaRequest.Builder.() -> Unit): UpgradeAppliedSchemaResponse = upgradeAppliedSchema(UpgradeAppliedSchemaRequest.Builder().apply(block).build())

/**
 * Upgrades a published schema under a new minor version revision using the current contents of `DevelopmentSchemaArn`.
 */
public suspend inline fun CloudDirectoryClient.upgradePublishedSchema(crossinline block: UpgradePublishedSchemaRequest.Builder.() -> Unit): UpgradePublishedSchemaResponse = upgradePublishedSchema(UpgradePublishedSchemaRequest.Builder().apply(block).build())
