// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the output of a CreateObject operation.
 */
public class BatchCreateObject private constructor(builder: Builder) {
    /**
     * The batch reference name. See [Transaction Support](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html) for more information.
     */
    public val batchReferenceName: kotlin.String? = builder.batchReferenceName
    /**
     * The name of the link.
     */
    public val linkName: kotlin.String? = builder.linkName
    /**
     * An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
     */
    public val objectAttributeList: List<AttributeKeyAndValue> = requireNotNull(builder.objectAttributeList) { "A non-null value must be provided for objectAttributeList" }
    /**
     * If specified, the parent reference to which this object will be attached.
     */
    public val parentReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.parentReference
    /**
     * A list of `FacetArns` that will be associated with the object. For more information, see arns.
     */
    public val schemaFacet: List<SchemaFacet> = requireNotNull(builder.schemaFacet) { "A non-null value must be provided for schemaFacet" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.BatchCreateObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchCreateObject(")
        append("batchReferenceName=$batchReferenceName,")
        append("linkName=$linkName,")
        append("objectAttributeList=$objectAttributeList,")
        append("parentReference=$parentReference,")
        append("schemaFacet=$schemaFacet")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchReferenceName?.hashCode() ?: 0
        result = 31 * result + (linkName?.hashCode() ?: 0)
        result = 31 * result + (objectAttributeList.hashCode())
        result = 31 * result + (parentReference?.hashCode() ?: 0)
        result = 31 * result + (schemaFacet.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchCreateObject

        if (batchReferenceName != other.batchReferenceName) return false
        if (linkName != other.linkName) return false
        if (objectAttributeList != other.objectAttributeList) return false
        if (parentReference != other.parentReference) return false
        if (schemaFacet != other.schemaFacet) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.BatchCreateObject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The batch reference name. See [Transaction Support](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html) for more information.
         */
        public var batchReferenceName: kotlin.String? = null
        /**
         * The name of the link.
         */
        public var linkName: kotlin.String? = null
        /**
         * An attribute map, which contains an attribute ARN as the key and attribute value as the map value.
         */
        public var objectAttributeList: List<AttributeKeyAndValue>? = null
        /**
         * If specified, the parent reference to which this object will be attached.
         */
        public var parentReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null
        /**
         * A list of `FacetArns` that will be associated with the object. For more information, see arns.
         */
        public var schemaFacet: List<SchemaFacet>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.BatchCreateObject) : this() {
            this.batchReferenceName = x.batchReferenceName
            this.linkName = x.linkName
            this.objectAttributeList = x.objectAttributeList
            this.parentReference = x.parentReference
            this.schemaFacet = x.schemaFacet
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.BatchCreateObject = BatchCreateObject(this)

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun parentReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.parentReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (objectAttributeList == null) objectAttributeList = emptyList()
            if (schemaFacet == null) schemaFacet = emptyList()
            return this
        }
    }
}
