// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.serde

import aws.sdk.kotlin.services.clouddirectory.model.ConsistencyLevel
import aws.sdk.kotlin.services.clouddirectory.model.ListOutgoingTypedLinksRequest
import aws.sdk.kotlin.services.clouddirectory.model.ObjectReference
import aws.sdk.kotlin.services.clouddirectory.model.TypedLinkAttributeRange
import aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListOutgoingTypedLinksOperationSerializer: HttpSerialize<ListOutgoingTypedLinksRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListOutgoingTypedLinksRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/amazonclouddirectory/2017-01-11/typedlink/outgoing"
        }

        builder.headers {
            if (input.directoryArn?.isNotEmpty() == true) append("x-amz-data-partition", input.directoryArn)
        }

        val payload = serializeListOutgoingTypedLinksOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListOutgoingTypedLinksOperationBody(context: ExecutionContext, input: ListOutgoingTypedLinksRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONSISTENCYLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ConsistencyLevel"))
    val FILTERATTRIBUTERANGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FilterAttributeRanges"))
    val FILTERTYPEDLINK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FilterTypedLink"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJECTREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ObjectReference"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSISTENCYLEVEL_DESCRIPTOR)
        field(FILTERATTRIBUTERANGES_DESCRIPTOR)
        field(FILTERTYPEDLINK_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(OBJECTREFERENCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.consistencyLevel?.let { field(CONSISTENCYLEVEL_DESCRIPTOR, it.value) }
        if (input.filterAttributeRanges != null) {
            listField(FILTERATTRIBUTERANGES_DESCRIPTOR) {
                for (el0 in input.filterAttributeRanges) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTypedLinkAttributeRangeDocument))
                }
            }
        }
        input.filterTypedLink?.let { field(FILTERTYPEDLINK_DESCRIPTOR, it, ::serializeTypedLinkSchemaAndFacetNameDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.objectReference?.let { field(OBJECTREFERENCE_DESCRIPTOR, it, ::serializeObjectReferenceDocument) }
    }
    return serializer.toByteArray()
}
