// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.serde

import aws.sdk.kotlin.services.clouddirectory.model.ConsistencyLevel
import aws.sdk.kotlin.services.clouddirectory.model.ListIndexRequest
import aws.sdk.kotlin.services.clouddirectory.model.ObjectAttributeRange
import aws.sdk.kotlin.services.clouddirectory.model.ObjectReference
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListIndexOperationSerializer: HttpSerialize<ListIndexRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListIndexRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/amazonclouddirectory/2017-01-11/index/targets"
        }

        builder.headers {
            if (input.consistencyLevel != null) append("x-amz-consistency-level", input.consistencyLevel.value)
            if (input.directoryArn?.isNotEmpty() == true) append("x-amz-data-partition", input.directoryArn)
        }

        val payload = serializeListIndexOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListIndexOperationBody(context: ExecutionContext, input: ListIndexRequest): ByteArray {
    val serializer = JsonSerializer()
    val INDEXREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IndexReference"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RANGESONINDEXEDVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RangesOnIndexedValues"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INDEXREFERENCE_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RANGESONINDEXEDVALUES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.indexReference?.let { field(INDEXREFERENCE_DESCRIPTOR, it, ::serializeObjectReferenceDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        if (input.rangesOnIndexedValues != null) {
            listField(RANGESONINDEXEDVALUES_DESCRIPTOR) {
                for (el0 in input.rangesOnIndexedValues) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeObjectAttributeRangeDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
