// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.serde

import aws.sdk.kotlin.services.clouddirectory.model.AttributeKeyAndValue
import aws.sdk.kotlin.services.clouddirectory.model.CloudDirectoryException
import aws.sdk.kotlin.services.clouddirectory.model.GetLinkAttributesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLinkAttributesOperationDeserializer: HttpDeserialize<GetLinkAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetLinkAttributesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetLinkAttributesError(context, call)
        }
        val builder = GetLinkAttributesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLinkAttributesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetLinkAttributesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudDirectoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FacetValidationException" -> FacetValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "RetryableConflictException" -> RetryableConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "DirectoryNotEnabledException" -> DirectoryNotEnabledExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudDirectoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLinkAttributesOperationBody(builder: GetLinkAttributesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Attributes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTRIBUTES_DESCRIPTOR.index -> builder.attributes =
                    deserializer.deserializeList(ATTRIBUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<AttributeKeyAndValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttributeKeyAndValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
