// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.serde

import aws.sdk.kotlin.services.clouddirectory.model.BatchWriteOperation
import aws.sdk.kotlin.services.clouddirectory.model.BatchWriteRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchWriteOperationSerializer: HttpSerialize<BatchWriteRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchWriteRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encoded = "/amazonclouddirectory/2017-01-11/batchwrite"
        }

        builder.headers {
            if (input.directoryArn?.isNotEmpty() == true) append("x-amz-data-partition", input.directoryArn)
        }

        val payload = serializeBatchWriteOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchWriteOperationBody(context: ExecutionContext, input: BatchWriteRequest): ByteArray {
    val serializer = JsonSerializer()
    val OPERATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Operations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(OPERATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.operations != null) {
            listField(OPERATIONS_DESCRIPTOR) {
                for (el0 in input.operations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBatchWriteOperationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
