// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.serde

import aws.sdk.kotlin.services.clouddirectory.model.AttachTypedLinkRequest
import aws.sdk.kotlin.services.clouddirectory.model.AttributeNameAndValue
import aws.sdk.kotlin.services.clouddirectory.model.ObjectReference
import aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AttachTypedLinkOperationSerializer: HttpSerialize<AttachTypedLinkRequest> {
    override suspend fun serialize(context: ExecutionContext, input: AttachTypedLinkRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encoded = "/amazonclouddirectory/2017-01-11/typedlink/attach"
        }

        builder.headers {
            if (input.directoryArn?.isNotEmpty() == true) append("x-amz-data-partition", input.directoryArn)
        }

        val payload = serializeAttachTypedLinkOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeAttachTypedLinkOperationBody(context: ExecutionContext, input: AttachTypedLinkRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Attributes"))
    val SOURCEOBJECTREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceObjectReference"))
    val TARGETOBJECTREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TargetObjectReference"))
    val TYPEDLINKFACET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TypedLinkFacet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
        field(SOURCEOBJECTREFERENCE_DESCRIPTOR)
        field(TARGETOBJECTREFERENCE_DESCRIPTOR)
        field(TYPEDLINKFACET_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributes != null) {
            listField(ATTRIBUTES_DESCRIPTOR) {
                for (el0 in input.attributes) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAttributeNameAndValueDocument))
                }
            }
        }
        input.sourceObjectReference?.let { field(SOURCEOBJECTREFERENCE_DESCRIPTOR, it, ::serializeObjectReferenceDocument) }
        input.targetObjectReference?.let { field(TARGETOBJECTREFERENCE_DESCRIPTOR, it, ::serializeObjectReferenceDocument) }
        input.typedLinkFacet?.let { field(TYPEDLINKFACET_DESCRIPTOR, it, ::serializeTypedLinkSchemaAndFacetNameDocument) }
    }
    return serializer.toByteArray()
}
