// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model



/**
 * Contains all the information that is used to uniquely identify a typed link. The parameters discussed in this topic are used to uniquely specify the typed link being operated on. The AttachTypedLink API returns a typed link specifier while the DetachTypedLink API accepts one as input. Similarly, the ListIncomingTypedLinks and ListOutgoingTypedLinks API operations provide typed link specifiers as output. You can also construct a typed link specifier from scratch.
 */
public class TypedLinkSpecifier private constructor(builder: Builder) {
    /**
     * Identifies the attribute value to update.
     */
    public val identityAttributeValues: List<AttributeNameAndValue> = requireNotNull(builder.identityAttributeValues) { "A non-null value must be provided for identityAttributeValues" }
    /**
     * Identifies the source object that the typed link will attach to.
     */
    public val sourceObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.sourceObjectReference
    /**
     * Identifies the target object that the typed link will attach to.
     */
    public val targetObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.targetObjectReference
    /**
     * Identifies the typed link facet that is associated with the typed link.
     */
    public val typedLinkFacet: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName? = builder.typedLinkFacet

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSpecifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TypedLinkSpecifier(")
        append("identityAttributeValues=$identityAttributeValues,")
        append("sourceObjectReference=$sourceObjectReference,")
        append("targetObjectReference=$targetObjectReference,")
        append("typedLinkFacet=$typedLinkFacet")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityAttributeValues.hashCode()
        result = 31 * result + (sourceObjectReference?.hashCode() ?: 0)
        result = 31 * result + (targetObjectReference?.hashCode() ?: 0)
        result = 31 * result + (typedLinkFacet?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TypedLinkSpecifier

        if (identityAttributeValues != other.identityAttributeValues) return false
        if (sourceObjectReference != other.sourceObjectReference) return false
        if (targetObjectReference != other.targetObjectReference) return false
        if (typedLinkFacet != other.typedLinkFacet) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSpecifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies the attribute value to update.
         */
        public var identityAttributeValues: List<AttributeNameAndValue>? = null
        /**
         * Identifies the source object that the typed link will attach to.
         */
        public var sourceObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null
        /**
         * Identifies the target object that the typed link will attach to.
         */
        public var targetObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null
        /**
         * Identifies the typed link facet that is associated with the typed link.
         */
        public var typedLinkFacet: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSpecifier) : this() {
            this.identityAttributeValues = x.identityAttributeValues
            this.sourceObjectReference = x.sourceObjectReference
            this.targetObjectReference = x.targetObjectReference
            this.typedLinkFacet = x.typedLinkFacet
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSpecifier = TypedLinkSpecifier(this)

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun sourceObjectReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.sourceObjectReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun targetObjectReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.targetObjectReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName] inside the given [block]
         */
        public fun typedLinkFacet(block: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName.Builder.() -> kotlin.Unit) {
            this.typedLinkFacet = aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (identityAttributeValues == null) identityAttributeValues = emptyList()
            return this
        }
    }
}
