// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model



/**
 * An attribute that is associated with the Facet.
 */
public class FacetAttribute private constructor(builder: Builder) {
    /**
     * A facet attribute consists of either a definition or a reference. This structure contains the attribute definition. See [Attribute References](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html) for more information.
     */
    public val attributeDefinition: aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeDefinition? = builder.attributeDefinition
    /**
     * An attribute reference that is associated with the attribute. See [Attribute References](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html) for more information.
     */
    public val attributeReference: aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeReference? = builder.attributeReference
    /**
     * The name of the facet attribute.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The required behavior of the `FacetAttribute`.
     */
    public val requiredBehavior: aws.sdk.kotlin.services.clouddirectory.model.RequiredAttributeBehavior? = builder.requiredBehavior

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.FacetAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FacetAttribute(")
        append("attributeDefinition=$attributeDefinition,")
        append("attributeReference=$attributeReference,")
        append("name=$name,")
        append("requiredBehavior=$requiredBehavior")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeDefinition?.hashCode() ?: 0
        result = 31 * result + (attributeReference?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (requiredBehavior?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FacetAttribute

        if (attributeDefinition != other.attributeDefinition) return false
        if (attributeReference != other.attributeReference) return false
        if (name != other.name) return false
        if (requiredBehavior != other.requiredBehavior) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.FacetAttribute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A facet attribute consists of either a definition or a reference. This structure contains the attribute definition. See [Attribute References](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html) for more information.
         */
        public var attributeDefinition: aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeDefinition? = null
        /**
         * An attribute reference that is associated with the attribute. See [Attribute References](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html) for more information.
         */
        public var attributeReference: aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeReference? = null
        /**
         * The name of the facet attribute.
         */
        public var name: kotlin.String? = null
        /**
         * The required behavior of the `FacetAttribute`.
         */
        public var requiredBehavior: aws.sdk.kotlin.services.clouddirectory.model.RequiredAttributeBehavior? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.FacetAttribute) : this() {
            this.attributeDefinition = x.attributeDefinition
            this.attributeReference = x.attributeReference
            this.name = x.name
            this.requiredBehavior = x.requiredBehavior
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.FacetAttribute = FacetAttribute(this)

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeDefinition] inside the given [block]
         */
        public fun attributeDefinition(block: aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeDefinition.Builder.() -> kotlin.Unit) {
            this.attributeDefinition = aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeReference] inside the given [block]
         */
        public fun attributeReference(block: aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeReference.Builder.() -> kotlin.Unit) {
            this.attributeReference = aws.sdk.kotlin.services.clouddirectory.model.FacetAttributeReference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
