// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.clouddirectory.model.CloudDirectoryException
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectPoliciesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListObjectPoliciesOperationDeserializer: HttpDeserialize<ListObjectPoliciesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListObjectPoliciesResponse {
        if (!response.status.isSuccess()) {
            throwListObjectPoliciesError(context, response)
        }
        val builder = ListObjectPoliciesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListObjectPoliciesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListObjectPoliciesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudDirectoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectoryNotEnabledException" -> DirectoryNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "RetryableConflictException" -> RetryableConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudDirectoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListObjectPoliciesOperationBody(builder: ListObjectPoliciesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTACHEDPOLICYIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AttachedPolicyIds"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTACHEDPOLICYIDS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTACHEDPOLICYIDS_DESCRIPTOR.index -> builder.attachedPolicyIds =
                    deserializer.deserializeList(ATTACHEDPOLICYIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
