// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.transform

import aws.sdk.kotlin.services.clouddirectory.model.ConsistencyLevel
import aws.sdk.kotlin.services.clouddirectory.model.ListObjectParentsRequest
import aws.sdk.kotlin.services.clouddirectory.model.ObjectReference
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListObjectParentsOperationSerializer: HttpSerialize<ListObjectParentsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListObjectParentsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/amazonclouddirectory/2017-01-11/object/parent"
        }

        builder.headers {
            if (input.consistencyLevel != null) append("x-amz-consistency-level", input.consistencyLevel.value)
            if (input.directoryArn?.isNotEmpty() == true) append("x-amz-data-partition", input.directoryArn)
        }

        val payload = serializeListObjectParentsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListObjectParentsOperationBody(context: ExecutionContext, input: ListObjectParentsRequest): ByteArray {
    val serializer = JsonSerializer()
    val INCLUDEALLLINKSTOEACHPARENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeAllLinksToEachParent"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJECTREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ObjectReference"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INCLUDEALLLINKSTOEACHPARENT_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(OBJECTREFERENCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.includeAllLinksToEachParent != false) field(INCLUDEALLLINKSTOEACHPARENT_DESCRIPTOR, input.includeAllLinksToEachParent)
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.objectReference?.let { field(OBJECTREFERENCE_DESCRIPTOR, it, ::serializeObjectReferenceDocument) }
    }
    return serializer.toByteArray()
}
