// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.clouddirectory.model.CloudDirectoryException
import aws.sdk.kotlin.services.clouddirectory.model.IndexAttachment
import aws.sdk.kotlin.services.clouddirectory.model.ListAttachedIndicesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListAttachedIndicesOperationDeserializer: HttpDeserialize<ListAttachedIndicesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAttachedIndicesResponse {
        if (!response.status.isSuccess()) {
            throwListAttachedIndicesError(context, response)
        }
        val builder = ListAttachedIndicesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAttachedIndicesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAttachedIndicesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudDirectoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectoryNotEnabledException" -> DirectoryNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "RetryableConflictException" -> RetryableConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudDirectoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAttachedIndicesOperationBody(builder: ListAttachedIndicesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INDEXATTACHMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("IndexAttachments"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INDEXATTACHMENTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INDEXATTACHMENTS_DESCRIPTOR.index -> builder.indexAttachments =
                    deserializer.deserializeList(INDEXATTACHMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<IndexAttachment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIndexAttachmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
