// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.transform

import aws.sdk.kotlin.services.clouddirectory.model.AttributeKeyAndValue
import aws.sdk.kotlin.services.clouddirectory.model.CreateObjectRequest
import aws.sdk.kotlin.services.clouddirectory.model.ObjectReference
import aws.sdk.kotlin.services.clouddirectory.model.SchemaFacet
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateObjectOperationSerializer: HttpSerialize<CreateObjectRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path = "/amazonclouddirectory/2017-01-11/object"
        }

        builder.headers {
            if (input.directoryArn?.isNotEmpty() == true) append("x-amz-data-partition", input.directoryArn)
        }

        val payload = serializeCreateObjectOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateObjectOperationBody(context: ExecutionContext, input: CreateObjectRequest): ByteArray {
    val serializer = JsonSerializer()
    val LINKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LinkName"))
    val OBJECTATTRIBUTELIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ObjectAttributeList"))
    val PARENTREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ParentReference"))
    val SCHEMAFACETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SchemaFacets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LINKNAME_DESCRIPTOR)
        field(OBJECTATTRIBUTELIST_DESCRIPTOR)
        field(PARENTREFERENCE_DESCRIPTOR)
        field(SCHEMAFACETS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.linkName?.let { field(LINKNAME_DESCRIPTOR, it) }
        if (input.objectAttributeList != null) {
            listField(OBJECTATTRIBUTELIST_DESCRIPTOR) {
                for (el0 in input.objectAttributeList) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAttributeKeyAndValueDocument))
                }
            }
        }
        input.parentReference?.let { field(PARENTREFERENCE_DESCRIPTOR, it, ::serializeObjectReferenceDocument) }
        if (input.schemaFacets != null) {
            listField(SCHEMAFACETS_DESCRIPTOR) {
                for (el0 in input.schemaFacets) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSchemaFacetDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
