// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model



/**
 * Defines the typed links structure and its attributes. To create a typed link facet, use the CreateTypedLinkFacet API.
 */
public class TypedLinkFacet private constructor(builder: Builder) {
    /**
     * A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data values that are related to the link itself, and not to one of the two objects being linked. Identity attributes also serve to distinguish the link from others of the same type between the same objects.
     */
    public val attributes: List<TypedLinkAttributeDefinition>? = builder.attributes
    /**
     * The set of attributes that distinguish links made from this facet from each other, in the order of significance. Listing typed links can filter on the values of these attributes. See ListOutgoingTypedLinks and ListIncomingTypedLinks for details.
     */
    public val identityAttributeOrder: List<String>? = builder.identityAttributeOrder
    /**
     * The unique name of the typed link facet.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.TypedLinkFacet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TypedLinkFacet(")
        append("attributes=$attributes,")
        append("identityAttributeOrder=$identityAttributeOrder,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (identityAttributeOrder?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TypedLinkFacet

        if (attributes != other.attributes) return false
        if (identityAttributeOrder != other.identityAttributeOrder) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.TypedLinkFacet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A set of key-value pairs associated with the typed link. Typed link attributes are used when you have data values that are related to the link itself, and not to one of the two objects being linked. Identity attributes also serve to distinguish the link from others of the same type between the same objects.
         */
        public var attributes: List<TypedLinkAttributeDefinition>? = null
        /**
         * The set of attributes that distinguish links made from this facet from each other, in the order of significance. Listing typed links can filter on the values of these attributes. See ListOutgoingTypedLinks and ListIncomingTypedLinks for details.
         */
        public var identityAttributeOrder: List<String>? = null
        /**
         * The unique name of the typed link facet.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkFacet) : this() {
            this.attributes = x.attributes
            this.identityAttributeOrder = x.identityAttributeOrder
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.TypedLinkFacet = TypedLinkFacet(this)
    }
}
