// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the data for a typed attribute. You can set one, and only one, of the elements. Each attribute in an item is a name-value pair. Attributes have a single value.
 */
public sealed class TypedAttributeValue {
    /**
     * A binary data value.
     */
    public data class BinaryValue(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.clouddirectory.model.TypedAttributeValue() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as BinaryValue

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }
    /**
     * A Boolean data value.
     */
    public data class BooleanValue(val value: kotlin.Boolean) : aws.sdk.kotlin.services.clouddirectory.model.TypedAttributeValue()
    /**
     * A date and time value.
     */
    public data class DatetimeValue(val value: aws.smithy.kotlin.runtime.time.Instant) : aws.sdk.kotlin.services.clouddirectory.model.TypedAttributeValue()
    /**
     * A number data value.
     */
    public data class NumberValue(val value: kotlin.String) : aws.sdk.kotlin.services.clouddirectory.model.TypedAttributeValue()
    /**
     * A string data value.
     */
    public data class StringValue(val value: kotlin.String) : aws.sdk.kotlin.services.clouddirectory.model.TypedAttributeValue()
    public object SdkUnknown : aws.sdk.kotlin.services.clouddirectory.model.TypedAttributeValue()

    /**
     * Casts this [TypedAttributeValue] as a [BinaryValue] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [TypedAttributeValue] is not a
     * [BinaryValue].
     */
    public fun asBinaryValue(): kotlin.ByteArray = (this as TypedAttributeValue.BinaryValue).value

    /**
     * Casts this [TypedAttributeValue] as a [BinaryValue] and retrieves its [kotlin.ByteArray] value. Returns null if the [TypedAttributeValue] is not a [BinaryValue].
     */
    public fun asBinaryValueOrNull(): kotlin.ByteArray? = (this as? TypedAttributeValue.BinaryValue)?.value

    /**
     * Casts this [TypedAttributeValue] as a [BooleanValue] and retrieves its [kotlin.Boolean] value. Throws an exception if the [TypedAttributeValue] is not a
     * [BooleanValue].
     */
    public fun asBooleanValue(): kotlin.Boolean = (this as TypedAttributeValue.BooleanValue).value

    /**
     * Casts this [TypedAttributeValue] as a [BooleanValue] and retrieves its [kotlin.Boolean] value. Returns null if the [TypedAttributeValue] is not a [BooleanValue].
     */
    public fun asBooleanValueOrNull(): kotlin.Boolean? = (this as? TypedAttributeValue.BooleanValue)?.value

    /**
     * Casts this [TypedAttributeValue] as a [DatetimeValue] and retrieves its [aws.smithy.kotlin.runtime.time.Instant] value. Throws an exception if the [TypedAttributeValue] is not a
     * [DatetimeValue].
     */
    public fun asDatetimeValue(): aws.smithy.kotlin.runtime.time.Instant = (this as TypedAttributeValue.DatetimeValue).value

    /**
     * Casts this [TypedAttributeValue] as a [DatetimeValue] and retrieves its [aws.smithy.kotlin.runtime.time.Instant] value. Returns null if the [TypedAttributeValue] is not a [DatetimeValue].
     */
    public fun asDatetimeValueOrNull(): aws.smithy.kotlin.runtime.time.Instant? = (this as? TypedAttributeValue.DatetimeValue)?.value

    /**
     * Casts this [TypedAttributeValue] as a [NumberValue] and retrieves its [kotlin.String] value. Throws an exception if the [TypedAttributeValue] is not a
     * [NumberValue].
     */
    public fun asNumberValue(): kotlin.String = (this as TypedAttributeValue.NumberValue).value

    /**
     * Casts this [TypedAttributeValue] as a [NumberValue] and retrieves its [kotlin.String] value. Returns null if the [TypedAttributeValue] is not a [NumberValue].
     */
    public fun asNumberValueOrNull(): kotlin.String? = (this as? TypedAttributeValue.NumberValue)?.value

    /**
     * Casts this [TypedAttributeValue] as a [StringValue] and retrieves its [kotlin.String] value. Throws an exception if the [TypedAttributeValue] is not a
     * [StringValue].
     */
    public fun asStringValue(): kotlin.String = (this as TypedAttributeValue.StringValue).value

    /**
     * Casts this [TypedAttributeValue] as a [StringValue] and retrieves its [kotlin.String] value. Returns null if the [TypedAttributeValue] is not a [StringValue].
     */
    public fun asStringValueOrNull(): kotlin.String? = (this as? TypedAttributeValue.StringValue)?.value
}
