// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.clouddirectory.model.*
import aws.sdk.kotlin.services.clouddirectory.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "CloudDirectory"
public const val ServiceApiVersion: String = "2017-01-11"
public const val SdkVersion: String = "0.17.7-beta"

internal class DefaultCloudDirectoryClient(override val config: CloudDirectoryClient.Config) : CloudDirectoryClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds a new Facet to an object. An object can have more than one facet applied on it.
     */
    override suspend fun addFacetToObject(input: AddFacetToObjectRequest): AddFacetToObjectResponse {
        val op = SdkHttpOperation.build<AddFacetToObjectRequest, AddFacetToObjectResponse> {
            serializer = AddFacetToObjectOperationSerializer()
            deserializer = AddFacetToObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddFacetToObject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies the input published schema, at the specified version, into the Directory with the same name and version as that of the published schema.
     */
    override suspend fun applySchema(input: ApplySchemaRequest): ApplySchemaResponse {
        val op = SdkHttpOperation.build<ApplySchemaRequest, ApplySchemaResponse> {
            serializer = ApplySchemaOperationSerializer()
            deserializer = ApplySchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApplySchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an existing object to another object. An object can be accessed in two ways:
     * + Using the path
     * + Using `ObjectIdentifier`
     */
    override suspend fun attachObject(input: AttachObjectRequest): AttachObjectResponse {
        val op = SdkHttpOperation.build<AttachObjectRequest, AttachObjectResponse> {
            serializer = AttachObjectOperationSerializer()
            deserializer = AttachObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachObject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     */
    override suspend fun attachPolicy(input: AttachPolicyRequest): AttachPolicyResponse {
        val op = SdkHttpOperation.build<AttachPolicyRequest, AttachPolicyResponse> {
            serializer = AttachPolicyOperationSerializer()
            deserializer = AttachPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches the specified object to the specified index.
     */
    override suspend fun attachToIndex(input: AttachToIndexRequest): AttachToIndexResponse {
        val op = SdkHttpOperation.build<AttachToIndexRequest, AttachToIndexResponse> {
            serializer = AttachToIndexOperationSerializer()
            deserializer = AttachToIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachToIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a typed link to a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun attachTypedLink(input: AttachTypedLinkRequest): AttachTypedLinkResponse {
        val op = SdkHttpOperation.build<AttachTypedLinkRequest, AttachTypedLinkResponse> {
            serializer = AttachTypedLinkOperationSerializer()
            deserializer = AttachTypedLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachTypedLink"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Performs all the read operations in a batch.
     */
    override suspend fun batchRead(input: BatchReadRequest): BatchReadResponse {
        val op = SdkHttpOperation.build<BatchReadRequest, BatchReadResponse> {
            serializer = BatchReadOperationSerializer()
            deserializer = BatchReadOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchRead"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Performs all the write operations in a batch. Either all the operations succeed or none.
     */
    override suspend fun batchWrite(input: BatchWriteRequest): BatchWriteResponse {
        val op = SdkHttpOperation.build<BatchWriteRequest, BatchWriteResponse> {
            serializer = BatchWriteOperationSerializer()
            deserializer = BatchWriteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchWrite"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Directory by copying the published schema into the directory. A directory cannot be created without a schema.
     *
     * You can also quickly create a directory using a managed schema, called the `QuickStartSchema`. For more information, see [Managed Schema](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html) in the *Amazon Cloud Directory Developer Guide*.
     */
    override suspend fun createDirectory(input: CreateDirectoryRequest): CreateDirectoryResponse {
        val op = SdkHttpOperation.build<CreateDirectoryRequest, CreateDirectoryResponse> {
            serializer = CreateDirectoryOperationSerializer()
            deserializer = CreateDirectoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDirectory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Facet in a schema. Facet creation is allowed only in development or applied schemas.
     */
    override suspend fun createFacet(input: CreateFacetRequest): CreateFacetResponse {
        val op = SdkHttpOperation.build<CreateFacetRequest, CreateFacetResponse> {
            serializer = CreateFacetOperationSerializer()
            deserializer = CreateFacetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFacet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an index object. See [Indexing and search](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html) for more information.
     */
    override suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse {
        val op = SdkHttpOperation.build<CreateIndexRequest, CreateIndexResponse> {
            serializer = CreateIndexOperationSerializer()
            deserializer = CreateIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an object in a Directory. Additionally attaches the object to a parent, if a parent reference and `LinkName` is specified. An object is simply a collection of Facet attributes. You can also use this API call to create a policy object, if the facet from which you create the object is a policy facet.
     */
    override suspend fun createObject(input: CreateObjectRequest): CreateObjectResponse {
        val op = SdkHttpOperation.build<CreateObjectRequest, CreateObjectResponse> {
            serializer = CreateObjectOperationSerializer()
            deserializer = CreateObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateObject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new schema in a development state. A schema can exist in three phases:
     * + *Development:* This is a mutable phase of the schema. All new schemas are in the development phase. Once the schema is finalized, it can be published.
     * + *Published:* Published schemas are immutable and have a version associated with them.
     * + *Applied:* Applied schemas are mutable in a way that allows you to add new schema facets. You can also add new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.
     */
    override suspend fun createSchema(input: CreateSchemaRequest): CreateSchemaResponse {
        val op = SdkHttpOperation.build<CreateSchemaRequest, CreateSchemaResponse> {
            serializer = CreateSchemaOperationSerializer()
            deserializer = CreateSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun createTypedLinkFacet(input: CreateTypedLinkFacetRequest): CreateTypedLinkFacetResponse {
        val op = SdkHttpOperation.build<CreateTypedLinkFacetRequest, CreateTypedLinkFacetResponse> {
            serializer = CreateTypedLinkFacetOperationSerializer()
            deserializer = CreateTypedLinkFacetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTypedLinkFacet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme caution when deleting directories.
     */
    override suspend fun deleteDirectory(input: DeleteDirectoryRequest): DeleteDirectoryResponse {
        val op = SdkHttpOperation.build<DeleteDirectoryRequest, DeleteDirectoryResponse> {
            serializer = DeleteDirectoryOperationSerializer()
            deserializer = DeleteDirectoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDirectory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a given Facet. All attributes and Rules that are associated with the facet will be deleted. Only development schema facets are allowed deletion.
     */
    override suspend fun deleteFacet(input: DeleteFacetRequest): DeleteFacetResponse {
        val op = SdkHttpOperation.build<DeleteFacetRequest, DeleteFacetResponse> {
            serializer = DeleteFacetOperationSerializer()
            deserializer = DeleteFacetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFacet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The maximum number of attributes that can be deleted during an object deletion is 30. For more information, see [Amazon Cloud Directory Limits](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
     */
    override suspend fun deleteObject(input: DeleteObjectRequest): DeleteObjectResponse {
        val op = SdkHttpOperation.build<DeleteObjectRequest, DeleteObjectResponse> {
            serializer = DeleteObjectOperationSerializer()
            deserializer = DeleteObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteObject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a given schema. Schemas in a development and published state can only be deleted.
     */
    override suspend fun deleteSchema(input: DeleteSchemaRequest): DeleteSchemaResponse {
        val op = SdkHttpOperation.build<DeleteSchemaRequest, DeleteSchemaResponse> {
            serializer = DeleteSchemaOperationSerializer()
            deserializer = DeleteSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun deleteTypedLinkFacet(input: DeleteTypedLinkFacetRequest): DeleteTypedLinkFacetResponse {
        val op = SdkHttpOperation.build<DeleteTypedLinkFacetRequest, DeleteTypedLinkFacetResponse> {
            serializer = DeleteTypedLinkFacetOperationSerializer()
            deserializer = DeleteTypedLinkFacetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTypedLinkFacet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches the specified object from the specified index.
     */
    override suspend fun detachFromIndex(input: DetachFromIndexRequest): DetachFromIndexResponse {
        val op = SdkHttpOperation.build<DetachFromIndexRequest, DetachFromIndexResponse> {
            serializer = DetachFromIndexOperationSerializer()
            deserializer = DetachFromIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachFromIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a given object from the parent object. The object that is to be detached from the parent is specified by the link name.
     */
    override suspend fun detachObject(input: DetachObjectRequest): DetachObjectResponse {
        val op = SdkHttpOperation.build<DetachObjectRequest, DetachObjectResponse> {
            serializer = DetachObjectOperationSerializer()
            deserializer = DetachObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachObject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a policy from an object.
     */
    override suspend fun detachPolicy(input: DetachPolicyRequest): DetachPolicyResponse {
        val op = SdkHttpOperation.build<DetachPolicyRequest, DetachPolicyResponse> {
            serializer = DetachPolicyOperationSerializer()
            deserializer = DetachPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a typed link from a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun detachTypedLink(input: DetachTypedLinkRequest): DetachTypedLinkResponse {
        val op = SdkHttpOperation.build<DetachTypedLinkRequest, DetachTypedLinkResponse> {
            serializer = DetachTypedLinkOperationSerializer()
            deserializer = DetachTypedLinkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachTypedLink"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can be disabled. Disabled directories may be reenabled.
     */
    override suspend fun disableDirectory(input: DisableDirectoryRequest): DisableDirectoryResponse {
        val op = SdkHttpOperation.build<DisableDirectoryRequest, DisableDirectoryResponse> {
            serializer = DisableDirectoryOperationSerializer()
            deserializer = DisableDirectoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableDirectory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then be read and written to.
     */
    override suspend fun enableDirectory(input: EnableDirectoryRequest): EnableDirectoryResponse {
        val op = SdkHttpOperation.build<EnableDirectoryRequest, EnableDirectoryResponse> {
            serializer = EnableDirectoryOperationSerializer()
            deserializer = EnableDirectoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableDirectory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns current applied schema version ARN, including the minor version in use.
     */
    override suspend fun getAppliedSchemaVersion(input: GetAppliedSchemaVersionRequest): GetAppliedSchemaVersionResponse {
        val op = SdkHttpOperation.build<GetAppliedSchemaVersionRequest, GetAppliedSchemaVersionResponse> {
            serializer = GetAppliedSchemaVersionOperationSerializer()
            deserializer = GetAppliedSchemaVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAppliedSchemaVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves metadata about a directory.
     */
    override suspend fun getDirectory(input: GetDirectoryRequest): GetDirectoryResponse {
        val op = SdkHttpOperation.build<GetDirectoryRequest, GetDirectoryResponse> {
            serializer = GetDirectoryOperationSerializer()
            deserializer = GetDirectoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDirectory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details of the Facet, such as facet name, attributes, Rules, or `ObjectType`. You can call this on all kinds of schema facets -- published, development, or applied.
     */
    override suspend fun getFacet(input: GetFacetRequest): GetFacetResponse {
        val op = SdkHttpOperation.build<GetFacetRequest, GetFacetResponse> {
            serializer = GetFacetOperationSerializer()
            deserializer = GetFacetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFacet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves attributes that are associated with a typed link.
     */
    override suspend fun getLinkAttributes(input: GetLinkAttributesRequest): GetLinkAttributesResponse {
        val op = SdkHttpOperation.build<GetLinkAttributesRequest, GetLinkAttributesResponse> {
            serializer = GetLinkAttributesOperationSerializer()
            deserializer = GetLinkAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLinkAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves attributes within a facet that are associated with an object.
     */
    override suspend fun getObjectAttributes(input: GetObjectAttributesRequest): GetObjectAttributesResponse {
        val op = SdkHttpOperation.build<GetObjectAttributesRequest, GetObjectAttributesResponse> {
            serializer = GetObjectAttributesOperationSerializer()
            deserializer = GetObjectAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetObjectAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves metadata about an object.
     */
    override suspend fun getObjectInformation(input: GetObjectInformationRequest): GetObjectInformationResponse {
        val op = SdkHttpOperation.build<GetObjectInformationRequest, GetObjectInformationResponse> {
            serializer = GetObjectInformationOperationSerializer()
            deserializer = GetObjectInformationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetObjectInformation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a JSON representation of the schema. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
     */
    override suspend fun getSchemaAsJson(input: GetSchemaAsJsonRequest): GetSchemaAsJsonResponse {
        val op = SdkHttpOperation.build<GetSchemaAsJsonRequest, GetSchemaAsJsonResponse> {
            serializer = GetSchemaAsJsonOperationSerializer()
            deserializer = GetSchemaAsJsonOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSchemaAsJson"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the identity attribute order for a specific TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun getTypedLinkFacetInformation(input: GetTypedLinkFacetInformationRequest): GetTypedLinkFacetInformationResponse {
        val op = SdkHttpOperation.build<GetTypedLinkFacetInformationRequest, GetTypedLinkFacetInformationResponse> {
            serializer = GetTypedLinkFacetInformationOperationSerializer()
            deserializer = GetTypedLinkFacetInformationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTypedLinkFacetInformation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists schema major versions applied to a directory. If `SchemaArn` is provided, lists the minor version.
     */
    override suspend fun listAppliedSchemaArns(input: ListAppliedSchemaArnsRequest): ListAppliedSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListAppliedSchemaArnsRequest, ListAppliedSchemaArnsResponse> {
            serializer = ListAppliedSchemaArnsOperationSerializer()
            deserializer = ListAppliedSchemaArnsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppliedSchemaArns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists indices attached to the specified object.
     */
    override suspend fun listAttachedIndices(input: ListAttachedIndicesRequest): ListAttachedIndicesResponse {
        val op = SdkHttpOperation.build<ListAttachedIndicesRequest, ListAttachedIndicesResponse> {
            serializer = ListAttachedIndicesOperationSerializer()
            deserializer = ListAttachedIndicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAttachedIndices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     */
    override suspend fun listDevelopmentSchemaArns(input: ListDevelopmentSchemaArnsRequest): ListDevelopmentSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListDevelopmentSchemaArnsRequest, ListDevelopmentSchemaArnsResponse> {
            serializer = ListDevelopmentSchemaArnsOperationSerializer()
            deserializer = ListDevelopmentSchemaArnsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevelopmentSchemaArns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists directories created within an account.
     */
    override suspend fun listDirectories(input: ListDirectoriesRequest): ListDirectoriesResponse {
        val op = SdkHttpOperation.build<ListDirectoriesRequest, ListDirectoriesResponse> {
            serializer = ListDirectoriesOperationSerializer()
            deserializer = ListDirectoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDirectories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves attributes attached to the facet.
     */
    override suspend fun listFacetAttributes(input: ListFacetAttributesRequest): ListFacetAttributesResponse {
        val op = SdkHttpOperation.build<ListFacetAttributesRequest, ListFacetAttributesResponse> {
            serializer = ListFacetAttributesOperationSerializer()
            deserializer = ListFacetAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFacetAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the names of facets that exist in a schema.
     */
    override suspend fun listFacetNames(input: ListFacetNamesRequest): ListFacetNamesResponse {
        val op = SdkHttpOperation.build<ListFacetNamesRequest, ListFacetNamesResponse> {
            serializer = ListFacetNamesOperationSerializer()
            deserializer = ListFacetNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFacetNames"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all the incoming TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun listIncomingTypedLinks(input: ListIncomingTypedLinksRequest): ListIncomingTypedLinksResponse {
        val op = SdkHttpOperation.build<ListIncomingTypedLinksRequest, ListIncomingTypedLinksResponse> {
            serializer = ListIncomingTypedLinksOperationSerializer()
            deserializer = ListIncomingTypedLinksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIncomingTypedLinks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists objects attached to the specified index.
     */
    override suspend fun listIndex(input: ListIndexRequest): ListIndexResponse {
        val op = SdkHttpOperation.build<ListIndexRequest, ListIndexResponse> {
            serializer = ListIndexOperationSerializer()
            deserializer = ListIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.
     */
    override suspend fun listManagedSchemaArns(input: ListManagedSchemaArnsRequest): ListManagedSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListManagedSchemaArnsRequest, ListManagedSchemaArnsResponse> {
            serializer = ListManagedSchemaArnsOperationSerializer()
            deserializer = ListManagedSchemaArnsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListManagedSchemaArns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all attributes that are associated with an object.
     */
    override suspend fun listObjectAttributes(input: ListObjectAttributesRequest): ListObjectAttributesResponse {
        val op = SdkHttpOperation.build<ListObjectAttributesRequest, ListObjectAttributesResponse> {
            serializer = ListObjectAttributesOperationSerializer()
            deserializer = ListObjectAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListObjectAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of child objects that are associated with a given object.
     */
    override suspend fun listObjectChildren(input: ListObjectChildrenRequest): ListObjectChildrenResponse {
        val op = SdkHttpOperation.build<ListObjectChildrenRequest, ListObjectChildrenResponse> {
            serializer = ListObjectChildrenOperationSerializer()
            deserializer = ListObjectChildrenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListObjectChildren"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see [Directory Structure](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
     *
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory up to the requested object. The API returns the number of paths based on user-defined `MaxResults`, in case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored from the target object.
     */
    override suspend fun listObjectParentPaths(input: ListObjectParentPathsRequest): ListObjectParentPathsResponse {
        val op = SdkHttpOperation.build<ListObjectParentPathsRequest, ListObjectParentPathsResponse> {
            serializer = ListObjectParentPathsOperationSerializer()
            deserializer = ListObjectParentPathsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListObjectParentPaths"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists parent objects that are associated with a given object in pagination fashion.
     */
    override suspend fun listObjectParents(input: ListObjectParentsRequest): ListObjectParentsResponse {
        val op = SdkHttpOperation.build<ListObjectParentsRequest, ListObjectParentsResponse> {
            serializer = ListObjectParentsOperationSerializer()
            deserializer = ListObjectParentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListObjectParents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns policies attached to an object in pagination fashion.
     */
    override suspend fun listObjectPolicies(input: ListObjectPoliciesRequest): ListObjectPoliciesResponse {
        val op = SdkHttpOperation.build<ListObjectPoliciesRequest, ListObjectPoliciesResponse> {
            serializer = ListObjectPoliciesOperationSerializer()
            deserializer = ListObjectPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListObjectPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all the outgoing TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun listOutgoingTypedLinks(input: ListOutgoingTypedLinksRequest): ListOutgoingTypedLinksResponse {
        val op = SdkHttpOperation.build<ListOutgoingTypedLinksRequest, ListOutgoingTypedLinksResponse> {
            serializer = ListOutgoingTypedLinksOperationSerializer()
            deserializer = ListOutgoingTypedLinksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOutgoingTypedLinks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all of the `ObjectIdentifiers` to which a given policy is attached.
     */
    override suspend fun listPolicyAttachments(input: ListPolicyAttachmentsRequest): ListPolicyAttachmentsResponse {
        val op = SdkHttpOperation.build<ListPolicyAttachmentsRequest, ListPolicyAttachmentsResponse> {
            serializer = ListPolicyAttachmentsOperationSerializer()
            deserializer = ListPolicyAttachmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPolicyAttachments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the major version families of each published schema. If a major version ARN is provided as `SchemaArn`, the minor version revisions in that family are listed instead.
     */
    override suspend fun listPublishedSchemaArns(input: ListPublishedSchemaArnsRequest): ListPublishedSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListPublishedSchemaArnsRequest, ListPublishedSchemaArnsResponse> {
            serializer = ListPublishedSchemaArnsOperationSerializer()
            deserializer = ListPublishedSchemaArnsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPublishedSchemaArns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per directory. All 50 tags are returned for a given directory with this API call.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all attribute definitions for a particular TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun listTypedLinkFacetAttributes(input: ListTypedLinkFacetAttributesRequest): ListTypedLinkFacetAttributesResponse {
        val op = SdkHttpOperation.build<ListTypedLinkFacetAttributesRequest, ListTypedLinkFacetAttributesResponse> {
            serializer = ListTypedLinkFacetAttributesOperationSerializer()
            deserializer = ListTypedLinkFacetAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTypedLinkFacetAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of `TypedLink` facet names for a particular schema. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun listTypedLinkFacetNames(input: ListTypedLinkFacetNamesRequest): ListTypedLinkFacetNamesResponse {
        val op = SdkHttpOperation.build<ListTypedLinkFacetNamesRequest, ListTypedLinkFacetNamesResponse> {
            serializer = ListTypedLinkFacetNamesOperationSerializer()
            deserializer = ListTypedLinkFacetNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTypedLinkFacetNames"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all policies from the root of the Directory to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the `ObjectIdentifier` for such objects. If policies are present, it returns `ObjectIdentifier`, `policyId`, and `policyType`. Paths that don't lead to the root from the target object are ignored. For more information, see [Policies](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
     */
    override suspend fun lookupPolicy(input: LookupPolicyRequest): LookupPolicyResponse {
        val op = SdkHttpOperation.build<LookupPolicyRequest, LookupPolicyResponse> {
            serializer = LookupPolicyOperationSerializer()
            deserializer = LookupPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "LookupPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Publishes a development schema with a major version and a recommended minor version.
     */
    override suspend fun publishSchema(input: PublishSchemaRequest): PublishSchemaResponse {
        val op = SdkHttpOperation.build<PublishSchemaRequest, PublishSchemaResponse> {
            serializer = PublishSchemaOperationSerializer()
            deserializer = PublishSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PublishSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows a schema to be updated using JSON upload. Only available for development schemas. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
     */
    override suspend fun putSchemaFromJson(input: PutSchemaFromJsonRequest): PutSchemaFromJsonResponse {
        val op = SdkHttpOperation.build<PutSchemaFromJsonRequest, PutSchemaFromJsonResponse> {
            serializer = PutSchemaFromJsonOperationSerializer()
            deserializer = PutSchemaFromJsonOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutSchemaFromJson"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified facet from the specified object.
     */
    override suspend fun removeFacetFromObject(input: RemoveFacetFromObjectRequest): RemoveFacetFromObjectResponse {
        val op = SdkHttpOperation.build<RemoveFacetFromObjectRequest, RemoveFacetFromObjectResponse> {
            serializer = RemoveFacetFromObjectOperationSerializer()
            deserializer = RemoveFacetFromObjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveFacetFromObject"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * An API operation for adding tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * An API operation for removing tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Does the following:
     * + Adds new `Attributes`, `Rules`, or `ObjectTypes`.
     * + Updates existing `Attributes`, `Rules`, or `ObjectTypes`.
     * + Deletes existing `Attributes`, `Rules`, or `ObjectTypes`.
     */
    override suspend fun updateFacet(input: UpdateFacetRequest): UpdateFacetResponse {
        val op = SdkHttpOperation.build<UpdateFacetRequest, UpdateFacetResponse> {
            serializer = UpdateFacetOperationSerializer()
            deserializer = UpdateFacetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFacet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its `IdentityAttributeOrder`.
     */
    override suspend fun updateLinkAttributes(input: UpdateLinkAttributesRequest): UpdateLinkAttributesResponse {
        val op = SdkHttpOperation.build<UpdateLinkAttributesRequest, UpdateLinkAttributesResponse> {
            serializer = UpdateLinkAttributesOperationSerializer()
            deserializer = UpdateLinkAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLinkAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a given object's attributes.
     */
    override suspend fun updateObjectAttributes(input: UpdateObjectAttributesRequest): UpdateObjectAttributesResponse {
        val op = SdkHttpOperation.build<UpdateObjectAttributesRequest, UpdateObjectAttributesResponse> {
            serializer = UpdateObjectAttributesOperationSerializer()
            deserializer = UpdateObjectAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateObjectAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the schema name with a new name. Only development schema names can be updated.
     */
    override suspend fun updateSchema(input: UpdateSchemaRequest): UpdateSchemaResponse {
        val op = SdkHttpOperation.build<UpdateSchemaRequest, UpdateSchemaResponse> {
            serializer = UpdateSchemaOperationSerializer()
            deserializer = UpdateSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun updateTypedLinkFacet(input: UpdateTypedLinkFacetRequest): UpdateTypedLinkFacetResponse {
        val op = SdkHttpOperation.build<UpdateTypedLinkFacetRequest, UpdateTypedLinkFacetResponse> {
            serializer = UpdateTypedLinkFacetOperationSerializer()
            deserializer = UpdateTypedLinkFacetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTypedLinkFacet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Upgrades a single directory in-place using the `PublishedSchemaArn` with schema updates found in `MinorVersion`. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.
     */
    override suspend fun upgradeAppliedSchema(input: UpgradeAppliedSchemaRequest): UpgradeAppliedSchemaResponse {
        val op = SdkHttpOperation.build<UpgradeAppliedSchemaRequest, UpgradeAppliedSchemaResponse> {
            serializer = UpgradeAppliedSchemaOperationSerializer()
            deserializer = UpgradeAppliedSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpgradeAppliedSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Upgrades a published schema under a new minor version revision using the current contents of `DevelopmentSchemaArn`.
     */
    override suspend fun upgradePublishedSchema(input: UpgradePublishedSchemaRequest): UpgradePublishedSchemaResponse {
        val op = SdkHttpOperation.build<UpgradePublishedSchemaRequest, UpgradePublishedSchemaResponse> {
            serializer = UpgradePublishedSchemaOperationSerializer()
            deserializer = UpgradePublishedSchemaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpgradePublishedSchema"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "clouddirectory"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "clouddirectory")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
