// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudcontrol.model.CloudControlException
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourceRequestsResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListResourceRequestsOperationDeserializer: HttpDeserialize<ListResourceRequestsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListResourceRequestsResponse {
        if (!response.status.isSuccess()) {
            throwListResourceRequestsError(context, response)
        }
        val builder = ListResourceRequestsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListResourceRequestsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListResourceRequestsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudControlException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> CloudControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListResourceRequestsOperationBody(builder: ListResourceRequestsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCEREQUESTSTATUSSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceRequestStatusSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCEREQUESTSTATUSSUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESOURCEREQUESTSTATUSSUMMARIES_DESCRIPTOR.index -> builder.resourceRequestStatusSummaries =
                    deserializer.deserializeList(RESOURCEREQUESTSTATUSSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProgressEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProgressEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
