// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudcontrol.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloudcontrol.model.*
import aws.sdk.kotlin.services.cloudcontrol.model.CancelResourceRequestRequest
import aws.sdk.kotlin.services.cloudcontrol.model.CancelResourceRequestResponse
import aws.sdk.kotlin.services.cloudcontrol.model.CreateResourceRequest
import aws.sdk.kotlin.services.cloudcontrol.model.CreateResourceResponse
import aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceRequest
import aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceResponse
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceRequest
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceRequestStatusRequest
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceRequestStatusResponse
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourceRequestsRequest
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourceRequestsResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesRequest
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesResponse
import aws.sdk.kotlin.services.cloudcontrol.model.UpdateResourceRequest
import aws.sdk.kotlin.services.cloudcontrol.model.UpdateResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * For more information about Amazon Web Services Cloud Control API, see the [Amazon Web Services Cloud Control API User Guide](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/what-is-cloudcontrolapi.html).
 */
public interface CloudControlClient : SdkClient {

    override val serviceName: String
        get() = "CloudControl"
    /**
     * CloudControlClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CloudControlClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCloudControlClient(config)
        }

        public operator fun invoke(config: Config): CloudControlClient = DefaultCloudControlClient(config)

        /**
         * Construct a [CloudControlClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CloudControlClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCloudControlClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels the specified resource operation request. For more information, see [Canceling resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-cancel) in the *Amazon Web Services Cloud Control API User Guide*.
     *
     * Only resource operations requests with a status of `PENDING` or `IN_PROGRESS` can be canceled.
     */
    public suspend fun cancelResourceRequest(input: CancelResourceRequestRequest): CancelResourceRequestResponse

    /**
     * Creates the specified resource. For more information, see [Creating a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html) in the *Amazon Web Services Cloud Control API User Guide*.
     *
     * After you have initiated a resource creation request, you can monitor the progress of your request by calling [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) using the `RequestToken` of the `ProgressEvent` type returned by `CreateResource`.
     */
    public suspend fun createResource(input: CreateResourceRequest): CreateResourceResponse

    /**
     * Deletes the specified resource. For details, see [Deleting a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-delete.html) in the *Amazon Web Services Cloud Control API User Guide*.
     *
     * After you have initiated a resource deletion request, you can monitor the progress of your request by calling [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) using the `RequestToken` of the `ProgressEvent` returned by `DeleteResource`.
     */
    public suspend fun deleteResource(input: DeleteResourceRequest): DeleteResourceResponse

    /**
     * Returns information about the current state of the specified resource. For details, see [Reading a resource's current state](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-read.html).
     *
     * You can use this action to return information about an existing resource in your account and Amazon Web Services Region, whether those resources were provisioned using Cloud Control API.
     */
    public suspend fun getResource(input: GetResourceRequest): GetResourceResponse

    /**
     * Returns the current status of a resource operation request. For more information, see [Tracking the progress of resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-track) in the *Amazon Web Services Cloud Control API User Guide*.
     */
    public suspend fun getResourceRequestStatus(input: GetResourceRequestStatusRequest): GetResourceRequestStatusResponse

    /**
     * Returns existing resource operation requests. This includes requests of all status types. For more information, see [Listing active resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-list) in the *Amazon Web Services Cloud Control API User Guide*.
     *
     * Resource operation requests expire after 7 days.
     */
    public suspend fun listResourceRequests(input: ListResourceRequestsRequest = ListResourceRequestsRequest {}): ListResourceRequestsResponse

    /**
     * Returns information about the specified resources. For more information, see [Discovering resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-list.html) in the *Amazon Web Services Cloud Control API User Guide*.
     *
     * You can use this action to return information about existing resources in your account and Amazon Web Services Region, whether those resources were provisioned using Cloud Control API.
     */
    public suspend fun listResources(input: ListResourcesRequest): ListResourcesResponse

    /**
     * Updates the specified property values in the resource.
     *
     * You specify your resource property updates as a list of patch operations contained in a JSON patch document that adheres to the *RFC 6902 - JavaScript Object Notation (JSON) Patch*[](https://datatracker.ietf.org/doc/html/rfc6902) standard.
     *
     * For details on how Cloud Control API performs resource update operations, see [Updating a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-update.html) in the *Amazon Web Services Cloud Control API User Guide*.
     *
     * After you have initiated a resource update request, you can monitor the progress of your request by calling [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) using the `RequestToken` of the `ProgressEvent` returned by `UpdateResource`.
     *
     * For more information about the properties of a specific resource, refer to the related topic for the resource in the [Resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation Users Guide*.
     */
    public suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse
}

/**
 * Cancels the specified resource operation request. For more information, see [Canceling resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-cancel) in the *Amazon Web Services Cloud Control API User Guide*.
 *
 * Only resource operations requests with a status of `PENDING` or `IN_PROGRESS` can be canceled.
 */
public suspend inline fun CloudControlClient.cancelResourceRequest(crossinline block: CancelResourceRequestRequest.Builder.() -> Unit): CancelResourceRequestResponse = cancelResourceRequest(CancelResourceRequestRequest.Builder().apply(block).build())

/**
 * Creates the specified resource. For more information, see [Creating a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html) in the *Amazon Web Services Cloud Control API User Guide*.
 *
 * After you have initiated a resource creation request, you can monitor the progress of your request by calling [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) using the `RequestToken` of the `ProgressEvent` type returned by `CreateResource`.
 */
public suspend inline fun CloudControlClient.createResource(crossinline block: CreateResourceRequest.Builder.() -> Unit): CreateResourceResponse = createResource(CreateResourceRequest.Builder().apply(block).build())

/**
 * Deletes the specified resource. For details, see [Deleting a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-delete.html) in the *Amazon Web Services Cloud Control API User Guide*.
 *
 * After you have initiated a resource deletion request, you can monitor the progress of your request by calling [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) using the `RequestToken` of the `ProgressEvent` returned by `DeleteResource`.
 */
public suspend inline fun CloudControlClient.deleteResource(crossinline block: DeleteResourceRequest.Builder.() -> Unit): DeleteResourceResponse = deleteResource(DeleteResourceRequest.Builder().apply(block).build())

/**
 * Returns information about the current state of the specified resource. For details, see [Reading a resource's current state](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-read.html).
 *
 * You can use this action to return information about an existing resource in your account and Amazon Web Services Region, whether those resources were provisioned using Cloud Control API.
 */
public suspend inline fun CloudControlClient.getResource(crossinline block: GetResourceRequest.Builder.() -> Unit): GetResourceResponse = getResource(GetResourceRequest.Builder().apply(block).build())

/**
 * Returns the current status of a resource operation request. For more information, see [Tracking the progress of resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-track) in the *Amazon Web Services Cloud Control API User Guide*.
 */
public suspend inline fun CloudControlClient.getResourceRequestStatus(crossinline block: GetResourceRequestStatusRequest.Builder.() -> Unit): GetResourceRequestStatusResponse = getResourceRequestStatus(GetResourceRequestStatusRequest.Builder().apply(block).build())

/**
 * Returns existing resource operation requests. This includes requests of all status types. For more information, see [Listing active resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html#resource-operations-manage-requests-list) in the *Amazon Web Services Cloud Control API User Guide*.
 *
 * Resource operation requests expire after 7 days.
 */
public suspend inline fun CloudControlClient.listResourceRequests(crossinline block: ListResourceRequestsRequest.Builder.() -> Unit): ListResourceRequestsResponse = listResourceRequests(ListResourceRequestsRequest.Builder().apply(block).build())

/**
 * Returns information about the specified resources. For more information, see [Discovering resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-list.html) in the *Amazon Web Services Cloud Control API User Guide*.
 *
 * You can use this action to return information about existing resources in your account and Amazon Web Services Region, whether those resources were provisioned using Cloud Control API.
 */
public suspend inline fun CloudControlClient.listResources(crossinline block: ListResourcesRequest.Builder.() -> Unit): ListResourcesResponse = listResources(ListResourcesRequest.Builder().apply(block).build())

/**
 * Updates the specified property values in the resource.
 *
 * You specify your resource property updates as a list of patch operations contained in a JSON patch document that adheres to the *RFC 6902 - JavaScript Object Notation (JSON) Patch*[](https://datatracker.ietf.org/doc/html/rfc6902) standard.
 *
 * For details on how Cloud Control API performs resource update operations, see [Updating a resource](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-update.html) in the *Amazon Web Services Cloud Control API User Guide*.
 *
 * After you have initiated a resource update request, you can monitor the progress of your request by calling [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) using the `RequestToken` of the `ProgressEvent` returned by `UpdateResource`.
 *
 * For more information about the properties of a specific resource, refer to the related topic for the resource in the [Resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation Users Guide*.
 */
public suspend inline fun CloudControlClient.updateResource(crossinline block: UpdateResourceRequest.Builder.() -> Unit): UpdateResourceResponse = updateResource(UpdateResourceRequest.Builder().apply(block).build())
