// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListResourcesRequest private constructor(builder: Builder) {
    /**
     * Reserved.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the previous paginated request didn't return all of the remaining results, the response object's `NextToken` parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object's `NextToken` parameter. If there are no remaining results, the previous response object's `NextToken` parameter is set to `null`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The resource model to use to select the resources to return.
     */
    public val resourceModel: kotlin.String? = builder.resourceModel
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the ` <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> ` section of the [resource type definition schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
     *
     * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.
     *
     * For more information, see [Specifying credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions) in the *Amazon Web Services Cloud Control API User Guide*.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The name of the resource type.
     */
    public val typeName: kotlin.String = requireNotNull(builder.typeName) { "A non-null value must be provided for typeName" }
    /**
     * For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.
     */
    public val typeVersionId: kotlin.String? = builder.typeVersionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResourcesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceModel=*** Sensitive Data Redacted ***,")
        append("roleArn=$roleArn,")
        append("typeName=$typeName,")
        append("typeVersionId=$typeVersionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceModel?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (typeName.hashCode())
        result = 31 * result + (typeVersionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResourcesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceModel != other.resourceModel) return false
        if (roleArn != other.roleArn) return false
        if (typeName != other.typeName) return false
        if (typeVersionId != other.typeVersionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Reserved.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If the previous paginated request didn't return all of the remaining results, the response object's `NextToken` parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object's `NextToken` parameter. If there are no remaining results, the previous response object's `NextToken` parameter is set to `null`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The resource model to use to select the resources to return.
         */
        public var resourceModel: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the ` <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> ` section of the [resource type definition schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
         *
         * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.
         *
         * For more information, see [Specifying credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions) in the *Amazon Web Services Cloud Control API User Guide*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the resource type.
         */
        public var typeName: kotlin.String? = null
        /**
         * For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.
         */
        public var typeVersionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceModel = x.resourceModel
            this.roleArn = x.roleArn
            this.typeName = x.typeName
            this.typeVersionId = x.typeVersionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesRequest = ListResourcesRequest(this)

        internal fun correctErrors(): Builder {
            if (typeName == null) typeName = ""
            return this
        }
    }
}
