// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.serde

import aws.sdk.kotlin.services.cloudcontrol.model.CloudControlException
import aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteResourceOperationDeserializer: HttpDeserializer.NonStreaming<DeleteResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteResourceError(context, call, payload)
        }
        val builder = DeleteResourceResponse.Builder()

        if (payload != null) {
            deserializeDeleteResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudControlException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "HandlerFailureException" -> HandlerFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotStabilizedException" -> NotStabilizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCredentialsException" -> InvalidCredentialsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLimitExceededException" -> ServiceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentOperationException" -> ConcurrentOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NetworkFailureException" -> NetworkFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceInternalErrorException" -> ServiceInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PrivateTypeException" -> PrivateTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "GeneralServiceException" -> GeneralServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "HandlerInternalFailureException" -> HandlerInternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotUpdatableException" -> NotUpdatableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientTokenConflictException" -> ClientTokenConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedActionException" -> UnsupportedActionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteResourceOperationBody(builder: DeleteResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROGRESSEVENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProgressEvent"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROGRESSEVENT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROGRESSEVENT_DESCRIPTOR.index -> builder.progressEvent = deserializeProgressEventDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
