// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.serde

import aws.sdk.kotlin.services.cloudcontrol.model.CloudControlException
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ResourceDescription
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListResourcesOperationDeserializer: HttpDeserializer.NonStreaming<ListResourcesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListResourcesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListResourcesError(context, call, payload)
        }
        val builder = ListResourcesResponse.Builder()

        if (payload != null) {
            deserializeListResourcesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListResourcesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudControlException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "HandlerFailureException" -> HandlerFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotStabilizedException" -> NotStabilizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCredentialsException" -> InvalidCredentialsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLimitExceededException" -> ServiceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NetworkFailureException" -> NetworkFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceInternalErrorException" -> ServiceInternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PrivateTypeException" -> PrivateTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "GeneralServiceException" -> GeneralServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "HandlerInternalFailureException" -> HandlerInternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotUpdatableException" -> NotUpdatableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedActionException" -> UnsupportedActionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListResourcesOperationBody(builder: ListResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCEDESCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceDescriptions"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCEDESCRIPTIONS_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESOURCEDESCRIPTIONS_DESCRIPTOR.index -> builder.resourceDescriptions =
                    deserializer.deserializeList(RESOURCEDESCRIPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResourceDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPENAME_DESCRIPTOR.index -> builder.typeName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
