// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.serde

import aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListResourcesOperationSerializer: HttpSerializer.NonStreaming<ListResourcesRequest> {
    override fun serialize(context: ExecutionContext, input: ListResourcesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeListResourcesOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeListResourcesOperationBody(context: ExecutionContext, input: ListResourcesRequest): ByteArray {
    val serializer = JsonSerializer()
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCEMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceModel"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeName"))
    val TYPEVERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeVersionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCEMODEL_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
        field(TYPEVERSIONID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.resourceModel?.let { field(RESOURCEMODEL_DESCRIPTOR, it) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        field(TYPENAME_DESCRIPTOR, input.typeName)
        input.typeVersionId?.let { field(TYPEVERSIONID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
