// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the current status of a resource operation request. For more information, see [Managing resource operation requests](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html) in the *Amazon Web Services Cloud Control API User Guide*.
 */
public class ProgressEvent private constructor(builder: Builder) {
    /**
     * For requests with a status of `FAILED`, the associated error code.
     *
     * For error code definitions, see [Handler error codes](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html) in the *CloudFormation Command Line Interface User Guide for Extension Development*.
     */
    public val errorCode: aws.sdk.kotlin.services.cloudcontrol.model.HandlerErrorCode? = builder.errorCode
    /**
     * When the resource operation request was initiated.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * The primary identifier for the resource.
     *
     * In some cases, the resource identifier may be available before the resource operation has reached a status of `SUCCESS`.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * The resource operation type.
     */
    public val operation: aws.sdk.kotlin.services.cloudcontrol.model.Operation? = builder.operation
    /**
     * The current status of the resource operation request.
     * + `PENDING`: The resource operation hasn't yet started.
     * + `IN_PROGRESS`: The resource operation is currently in progress.
     * + `SUCCESS`: The resource operation has successfully completed.
     * + `FAILED`: The resource operation has failed. Refer to the error code and status message for more information.
     * + `CANCEL_IN_PROGRESS`: The resource operation is in the process of being canceled.
     * + `CANCEL_COMPLETE`: The resource operation has been canceled.
     */
    public val operationStatus: aws.sdk.kotlin.services.cloudcontrol.model.OperationStatus? = builder.operationStatus
    /**
     * The unique token representing this resource operation request.
     *
     * Use the `RequestToken` with [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) to return the current status of a resource operation request.
     */
    public val requestToken: kotlin.String? = builder.requestToken
    /**
     * A JSON string containing the resource model, consisting of each resource property and its current value.
     */
    public val resourceModel: kotlin.String? = builder.resourceModel
    /**
     * When to next request the status of this resource operation request.
     */
    public val retryAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.retryAfter
    /**
     * Any message explaining the current status.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The name of the resource type used in the operation.
     */
    public val typeName: kotlin.String? = builder.typeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProgressEvent(")
        append("errorCode=$errorCode,")
        append("eventTime=$eventTime,")
        append("identifier=$identifier,")
        append("operation=$operation,")
        append("operationStatus=$operationStatus,")
        append("requestToken=$requestToken,")
        append("resourceModel=*** Sensitive Data Redacted ***,")
        append("retryAfter=$retryAfter,")
        append("statusMessage=$statusMessage,")
        append("typeName=$typeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (operationStatus?.hashCode() ?: 0)
        result = 31 * result + (requestToken?.hashCode() ?: 0)
        result = 31 * result + (resourceModel?.hashCode() ?: 0)
        result = 31 * result + (retryAfter?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProgressEvent

        if (errorCode != other.errorCode) return false
        if (eventTime != other.eventTime) return false
        if (identifier != other.identifier) return false
        if (operation != other.operation) return false
        if (operationStatus != other.operationStatus) return false
        if (requestToken != other.requestToken) return false
        if (resourceModel != other.resourceModel) return false
        if (retryAfter != other.retryAfter) return false
        if (statusMessage != other.statusMessage) return false
        if (typeName != other.typeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For requests with a status of `FAILED`, the associated error code.
         *
         * For error code definitions, see [Handler error codes](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-test-contract-errors.html) in the *CloudFormation Command Line Interface User Guide for Extension Development*.
         */
        public var errorCode: aws.sdk.kotlin.services.cloudcontrol.model.HandlerErrorCode? = null
        /**
         * When the resource operation request was initiated.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The primary identifier for the resource.
         *
         * In some cases, the resource identifier may be available before the resource operation has reached a status of `SUCCESS`.
         */
        public var identifier: kotlin.String? = null
        /**
         * The resource operation type.
         */
        public var operation: aws.sdk.kotlin.services.cloudcontrol.model.Operation? = null
        /**
         * The current status of the resource operation request.
         * + `PENDING`: The resource operation hasn't yet started.
         * + `IN_PROGRESS`: The resource operation is currently in progress.
         * + `SUCCESS`: The resource operation has successfully completed.
         * + `FAILED`: The resource operation has failed. Refer to the error code and status message for more information.
         * + `CANCEL_IN_PROGRESS`: The resource operation is in the process of being canceled.
         * + `CANCEL_COMPLETE`: The resource operation has been canceled.
         */
        public var operationStatus: aws.sdk.kotlin.services.cloudcontrol.model.OperationStatus? = null
        /**
         * The unique token representing this resource operation request.
         *
         * Use the `RequestToken` with [GetResourceRequestStatus](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html) to return the current status of a resource operation request.
         */
        public var requestToken: kotlin.String? = null
        /**
         * A JSON string containing the resource model, consisting of each resource property and its current value.
         */
        public var resourceModel: kotlin.String? = null
        /**
         * When to next request the status of this resource operation request.
         */
        public var retryAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Any message explaining the current status.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The name of the resource type used in the operation.
         */
        public var typeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent) : this() {
            this.errorCode = x.errorCode
            this.eventTime = x.eventTime
            this.identifier = x.identifier
            this.operation = x.operation
            this.operationStatus = x.operationStatus
            this.requestToken = x.requestToken
            this.resourceModel = x.resourceModel
            this.retryAfter = x.retryAfter
            this.statusMessage = x.statusMessage
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent = ProgressEvent(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
