// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.transform

import aws.sdk.kotlin.services.cloudcontrol.model.CloudControlException
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ResourceDescription
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResourceOperationDeserializer: HttpDeserialize<GetResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetResourceError(context, call)
        }
        val builder = GetResourceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetResourceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudControlException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "GeneralServiceException" -> GeneralServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "HandlerFailureException" -> HandlerFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "HandlerInternalFailureException" -> HandlerInternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCredentialsException" -> InvalidCredentialsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "NetworkFailureException" -> NetworkFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "NotStabilizedException" -> NotStabilizedExceptionDeserializer().deserialize(context, wrappedCall)
        "NotUpdatableException" -> NotUpdatableExceptionDeserializer().deserialize(context, wrappedCall)
        "PrivateTypeException" -> PrivateTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceInternalErrorException" -> ServiceInternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceLimitExceededException" -> ServiceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedActionException" -> UnsupportedActionExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceOperationBody(builder: GetResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESOURCEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResourceDescription"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOURCEDESCRIPTION_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESOURCEDESCRIPTION_DESCRIPTOR.index -> builder.resourceDescription = deserializeResourceDescriptionDocument(deserializer)
                TYPENAME_DESCRIPTOR.index -> builder.typeName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
