// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.transform

import aws.sdk.kotlin.services.cloudcontrol.model.CloudControlException
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ResourceDescription
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListResourcesOperationDeserializer: HttpDeserialize<ListResourcesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListResourcesResponse {
        if (!response.status.isSuccess()) {
            throwListResourcesError(context, response)
        }
        val builder = ListResourcesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListResourcesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListResourcesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudControlException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "GeneralServiceException" -> GeneralServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandlerFailureException" -> HandlerFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandlerInternalFailureException" -> HandlerInternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCredentialsException" -> InvalidCredentialsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NetworkFailureException" -> NetworkFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotStabilizedException" -> NotStabilizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotUpdatableException" -> NotUpdatableExceptionDeserializer().deserialize(context, wrappedResponse)
        "PrivateTypeException" -> PrivateTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceInternalErrorException" -> ServiceInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceLimitExceededException" -> ServiceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedActionException" -> UnsupportedActionExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListResourcesOperationBody(builder: ListResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCEDESCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceDescriptions"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCEDESCRIPTIONS_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESOURCEDESCRIPTIONS_DESCRIPTOR.index -> builder.resourceDescriptions =
                    deserializer.deserializeList(RESOURCEDESCRIPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResourceDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPENAME_DESCRIPTOR.index -> builder.typeName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
