// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.model



public class DeleteResourceRequest private constructor(builder: Builder) {
    /**
     * A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between request retries and new resource requests. You might retry a resource request to ensure that it was successfully received.
     *
     * A client token is valid for 36 hours once used. After that, a resource request with the same client token is treated as a new request.
     *
     * If you do not specify a client token, one is generated for inclusion in the request.
     *
     * For more information, see [Ensuring resource operation requests are unique](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency) in the *Amazon Web Services Cloud Control API User Guide*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier for the resource.
     *
     * You can specify the primary identifier, or any secondary identifier defined for the resource type in its resource schema. You can only specify one identifier. Primary identifiers can be specified as a string or JSON; secondary identifiers must be specified as JSON.
     *
     * For compound primary identifiers (that is, one that consists of multiple resource properties strung together), to specify the primary identifier as a string, list the property values *in the order they are specified* in the primary identifier definition, separated by `|`.
     *
     * For more information, see [Identifying resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html) in the *Amazon Web Services Cloud Control API User Guide*.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the ` <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> ` section of the [resource type definition schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
     *
     * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.
     *
     * For more information, see [Specifying credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions) in the *Amazon Web Services Cloud Control API User Guide*.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The name of the resource type.
     */
    public val typeName: kotlin.String? = builder.typeName
    /**
     * For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.
     */
    public val typeVersionId: kotlin.String? = builder.typeVersionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteResourceRequest(")
        append("clientToken=$clientToken,")
        append("identifier=$identifier,")
        append("roleArn=$roleArn,")
        append("typeName=$typeName,")
        append("typeVersionId=$typeVersionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (typeVersionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteResourceRequest

        if (clientToken != other.clientToken) return false
        if (identifier != other.identifier) return false
        if (roleArn != other.roleArn) return false
        if (typeName != other.typeName) return false
        if (typeVersionId != other.typeVersionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between request retries and new resource requests. You might retry a resource request to ensure that it was successfully received.
         *
         * A client token is valid for 36 hours once used. After that, a resource request with the same client token is treated as a new request.
         *
         * If you do not specify a client token, one is generated for inclusion in the request.
         *
         * For more information, see [Ensuring resource operation requests are unique](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency) in the *Amazon Web Services Cloud Control API User Guide*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier for the resource.
         *
         * You can specify the primary identifier, or any secondary identifier defined for the resource type in its resource schema. You can only specify one identifier. Primary identifiers can be specified as a string or JSON; secondary identifiers must be specified as JSON.
         *
         * For compound primary identifiers (that is, one that consists of multiple resource properties strung together), to specify the primary identifier as a string, list the property values *in the order they are specified* in the primary identifier definition, separated by `|`.
         *
         * For more information, see [Identifying resources](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html) in the *Amazon Web Services Cloud Control API User Guide*.
         */
        public var identifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when performing this resource operation. The role specified must have the permissions required for this operation. The necessary permissions for each event handler are defined in the ` <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> ` section of the [resource type definition schema](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html).
         *
         * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services user credentials.
         *
         * For more information, see [Specifying credentials](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions) in the *Amazon Web Services Cloud Control API User Guide*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the resource type.
         */
        public var typeName: kotlin.String? = null
        /**
         * For private resource types, the type version to use in this resource operation. If you do not specify a resource version, CloudFormation uses the default version.
         */
        public var typeVersionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceRequest) : this() {
            this.clientToken = x.clientToken
            this.identifier = x.identifier
            this.roleArn = x.roleArn
            this.typeName = x.typeName
            this.typeVersionId = x.typeVersionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceRequest = DeleteResourceRequest(this)
    }
}
