// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.waiters

import aws.sdk.kotlin.services.cloudcontrol.CloudControlClient
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceRequestStatusRequest
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceRequestStatusResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until resource operation request is successful
 */
suspend fun CloudControlClient.waitUntilResourceRequestSuccess(request: GetResourceRequestStatusRequest): Outcome<GetResourceRequestStatusResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetResourceRequestStatusRequest, GetResourceRequestStatusResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val progressEvent = it?.progressEvent
            val operationStatus = progressEvent?.operationStatus
            operationStatus?.toString() == "SUCCESS"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val progressEvent = it?.progressEvent
            val operationStatus = progressEvent?.operationStatus
            operationStatus?.toString() == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val progressEvent = it?.progressEvent
            val operationStatus = progressEvent?.operationStatus
            operationStatus?.toString() == "CANCEL_COMPLETE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getResourceRequestStatus(request) }
}

/**
 * Wait until resource operation request is successful
 */
suspend fun CloudControlClient.waitUntilResourceRequestSuccess(block: GetResourceRequestStatusRequest.Builder.() -> Unit): Outcome<GetResourceRequestStatusResponse> =
    waitUntilResourceRequestSuccess(GetResourceRequestStatusRequest.Builder().apply(block).build())
