// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudcontrol.model.CloudControlException
import aws.sdk.kotlin.services.cloudcontrol.model.GetResourceRequestStatusResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResourceRequestStatusOperationDeserializer: HttpDeserialize<GetResourceRequestStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetResourceRequestStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetResourceRequestStatusError(context, response)
        }
        val builder = GetResourceRequestStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResourceRequestStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetResourceRequestStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudControlException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RequestTokenNotFoundException" -> RequestTokenNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceRequestStatusOperationBody(builder: GetResourceRequestStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROGRESSEVENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProgressEvent"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROGRESSEVENT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROGRESSEVENT_DESCRIPTOR.index -> builder.progressEvent = deserializeProgressEventDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
