// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudcontrol.model.CloudControlException
import aws.sdk.kotlin.services.cloudcontrol.model.DeleteResourceResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteResourceOperationDeserializer: HttpDeserialize<DeleteResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteResourceResponse {
        if (!response.status.isSuccess()) {
            throwDeleteResourceError(context, response)
        }
        val builder = DeleteResourceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteResourceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudControlException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ClientTokenConflictException" -> ClientTokenConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentOperationException" -> ConcurrentOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "GeneralServiceException" -> GeneralServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandlerFailureException" -> HandlerFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "HandlerInternalFailureException" -> HandlerInternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCredentialsException" -> InvalidCredentialsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NetworkFailureException" -> NetworkFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotStabilizedException" -> NotStabilizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotUpdatableException" -> NotUpdatableExceptionDeserializer().deserialize(context, wrappedResponse)
        "PrivateTypeException" -> PrivateTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceInternalErrorException" -> ServiceInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceLimitExceededException" -> ServiceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedActionException" -> UnsupportedActionExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteResourceOperationBody(builder: DeleteResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROGRESSEVENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProgressEvent"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROGRESSEVENT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROGRESSEVENT_DESCRIPTOR.index -> builder.progressEvent = deserializeProgressEventDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
