// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudcontrol.paginators

import aws.sdk.kotlin.services.cloudcontrol.CloudControlClient
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourceRequestsRequest
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourceRequestsResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesRequest
import aws.sdk.kotlin.services.cloudcontrol.model.ListResourcesResponse
import aws.sdk.kotlin.services.cloudcontrol.model.ProgressEvent
import aws.sdk.kotlin.services.cloudcontrol.model.ResourceDescription
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListResourceRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceRequestsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceRequestsResponse]
 */
fun CloudControlClient.listResourceRequestsPaginated(initialRequest: ListResourceRequestsRequest): Flow<ListResourceRequestsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceRequestsPaginated.listResourceRequests(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceRequestsResponse]
 */
fun CloudControlClient.listResourceRequestsPaginated(block: ListResourceRequestsRequest.Builder.() -> Unit): Flow<ListResourceRequestsResponse> =
    listResourceRequestsPaginated(ListResourceRequestsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceRequestsPaginated]
 * to access the nested member [ProgressEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProgressEvent]
 */
@JvmName("listResourceRequestsResponseProgressEvent")
fun Flow<ListResourceRequestsResponse>.resourceRequestStatusSummaries(): Flow<ProgressEvent> =
    transform() { response ->
        response.resourceRequestStatusSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesResponse]
 */
fun CloudControlClient.listResourcesPaginated(initialRequest: ListResourcesRequest): Flow<ListResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourcesPaginated.listResources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesResponse]
 */
fun CloudControlClient.listResourcesPaginated(block: ListResourcesRequest.Builder.() -> Unit): Flow<ListResourcesResponse> =
    listResourcesPaginated(ListResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourcesPaginated]
 * to access the nested member [ResourceDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceDescription]
 */
@JvmName("listResourcesResponseResourceDescription")
fun Flow<ListResourcesResponse>.resourceDescriptions(): Flow<ResourceDescription> =
    transform() { response ->
        response.resourceDescriptions?.forEach {
            emit(it)
        }
    }
