// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an environment member for an Cloud9 development environment.
 */
class EnvironmentMember private constructor(builder: BuilderImpl) {
    /**
     * The ID of the environment for the environment member.
     */
    val environmentId: String? = builder.environmentId
    /**
     * The time, expressed in epoch time format, when the environment member last opened the
     * environment.
     */
    val lastAccess: Instant? = builder.lastAccess
    /**
     * The type of environment member permissions associated with this environment member.
     * Available values include:
     * owner: Owns the environment.
     * read-only: Has read-only access to the environment.
     * read-write: Has read-write access to the environment.
     */
    val permissions: Permissions? = builder.permissions
    /**
     * The Amazon Resource Name (ARN) of the environment member.
     */
    val userArn: String? = builder.userArn
    /**
     * The user ID in Identity and Access Management (IAM) of the environment member.
     */
    val userId: String? = builder.userId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EnvironmentMember = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentMember(")
        append("environmentId=$environmentId,")
        append("lastAccess=$lastAccess,")
        append("permissions=$permissions,")
        append("userArn=$userArn,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentId?.hashCode() ?: 0
        result = 31 * result + (lastAccess?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (userArn?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EnvironmentMember

        if (environmentId != other.environmentId) return false
        if (lastAccess != other.lastAccess) return false
        if (permissions != other.permissions) return false
        if (userArn != other.userArn) return false
        if (userId != other.userId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EnvironmentMember = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EnvironmentMember
        /**
         * The ID of the environment for the environment member.
         */
        fun environmentId(environmentId: String): FluentBuilder
        /**
         * The time, expressed in epoch time format, when the environment member last opened the
         * environment.
         */
        fun lastAccess(lastAccess: Instant): FluentBuilder
        /**
         * The type of environment member permissions associated with this environment member.
         * Available values include:
         * owner: Owns the environment.
         * read-only: Has read-only access to the environment.
         * read-write: Has read-write access to the environment.
         */
        fun permissions(permissions: Permissions): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the environment member.
         */
        fun userArn(userArn: String): FluentBuilder
        /**
         * The user ID in Identity and Access Management (IAM) of the environment member.
         */
        fun userId(userId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the environment for the environment member.
         */
        var environmentId: String?
        /**
         * The time, expressed in epoch time format, when the environment member last opened the
         * environment.
         */
        var lastAccess: Instant?
        /**
         * The type of environment member permissions associated with this environment member.
         * Available values include:
         * owner: Owns the environment.
         * read-only: Has read-only access to the environment.
         * read-write: Has read-write access to the environment.
         */
        var permissions: Permissions?
        /**
         * The Amazon Resource Name (ARN) of the environment member.
         */
        var userArn: String?
        /**
         * The user ID in Identity and Access Management (IAM) of the environment member.
         */
        var userId: String?

        fun build(): EnvironmentMember
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var environmentId: String? = null
        override var lastAccess: Instant? = null
        override var permissions: Permissions? = null
        override var userArn: String? = null
        override var userId: String? = null

        constructor(x: EnvironmentMember) : this() {
            this.environmentId = x.environmentId
            this.lastAccess = x.lastAccess
            this.permissions = x.permissions
            this.userArn = x.userArn
            this.userId = x.userId
        }

        override fun build(): EnvironmentMember = EnvironmentMember(this)
        override fun environmentId(environmentId: String): FluentBuilder = apply { this.environmentId = environmentId }
        override fun lastAccess(lastAccess: Instant): FluentBuilder = apply { this.lastAccess = lastAccess }
        override fun permissions(permissions: Permissions): FluentBuilder = apply { this.permissions = permissions }
        override fun userArn(userArn: String): FluentBuilder = apply { this.userArn = userArn }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
    }
}
