// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model



/**
 * Information about the current creation or deletion lifecycle state of an Cloud9 development
 * environment.
 */
class EnvironmentLifecycle private constructor(builder: BuilderImpl) {
    /**
     * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services
     * resource.
     */
    val failureResource: String? = builder.failureResource
    /**
     * Any informational message about the lifecycle state of the environment.
     */
    val reason: String? = builder.reason
    /**
     * The current creation or deletion lifecycle state of the environment.
     * CREATING: The environment is in the process of being created.
     * CREATED: The environment was successfully created.
     * CREATE_FAILED: The environment failed to be created.
     * DELETING: The environment is in the process of being deleted.
     * DELETE_FAILED: The environment failed to delete.
     */
    val status: EnvironmentLifecycleStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EnvironmentLifecycle = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentLifecycle(")
        append("failureResource=$failureResource,")
        append("reason=$reason,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureResource?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EnvironmentLifecycle

        if (failureResource != other.failureResource) return false
        if (reason != other.reason) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EnvironmentLifecycle = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EnvironmentLifecycle
        /**
         * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services
         * resource.
         */
        fun failureResource(failureResource: String): FluentBuilder
        /**
         * Any informational message about the lifecycle state of the environment.
         */
        fun reason(reason: String): FluentBuilder
        /**
         * The current creation or deletion lifecycle state of the environment.
         * CREATING: The environment is in the process of being created.
         * CREATED: The environment was successfully created.
         * CREATE_FAILED: The environment failed to be created.
         * DELETING: The environment is in the process of being deleted.
         * DELETE_FAILED: The environment failed to delete.
         */
        fun status(status: EnvironmentLifecycleStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services
         * resource.
         */
        var failureResource: String?
        /**
         * Any informational message about the lifecycle state of the environment.
         */
        var reason: String?
        /**
         * The current creation or deletion lifecycle state of the environment.
         * CREATING: The environment is in the process of being created.
         * CREATED: The environment was successfully created.
         * CREATE_FAILED: The environment failed to be created.
         * DELETING: The environment is in the process of being deleted.
         * DELETE_FAILED: The environment failed to delete.
         */
        var status: EnvironmentLifecycleStatus?

        fun build(): EnvironmentLifecycle
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var failureResource: String? = null
        override var reason: String? = null
        override var status: EnvironmentLifecycleStatus? = null

        constructor(x: EnvironmentLifecycle) : this() {
            this.failureResource = x.failureResource
            this.reason = x.reason
            this.status = x.status
        }

        override fun build(): EnvironmentLifecycle = EnvironmentLifecycle(this)
        override fun failureResource(failureResource: String): FluentBuilder = apply { this.failureResource = failureResource }
        override fun reason(reason: String): FluentBuilder = apply { this.reason = reason }
        override fun status(status: EnvironmentLifecycleStatus): FluentBuilder = apply { this.status = status }
    }
}
