// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.cloud9.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloud9.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Cloud9</fullname>
 * Cloud9 is a collection of tools that you can use to code, build, run, test, debug, and
 * release software in the cloud.
 * For more information about Cloud9, see the <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide">Cloud9 User Guide.
 * Cloud9 supports these operations:
 * CreateEnvironmentEC2: Creates an Cloud9 development environment, launches
 * an Amazon EC2 instance, and then connects from the instance to the environment.
 * CreateEnvironmentMembership: Adds an environment member to an
 * environment.
 * DeleteEnvironment: Deletes an environment. If an Amazon EC2 instance is
 * connected to the environment, also terminates the instance.
 * DeleteEnvironmentMembership: Deletes an environment member from an
 * environment.
 * DescribeEnvironmentMemberships: Gets information about environment
 * members for an environment.
 * DescribeEnvironments: Gets information about environments.
 * DescribeEnvironmentStatus: Gets status information for an
 * environment.
 * ListEnvironments: Gets a list of environment identifiers.
 * ListTagsForResource: Gets the tags for an environment.
 * TagResource: Adds tags to an environment.
 * UntagResource: Removes tags from an environment.
 * UpdateEnvironment: Changes the settings of an existing
 * environment.
 * UpdateEnvironmentMembership: Changes the settings of an existing
 * environment member for an environment.
 */
interface Cloud9Client : SdkClient {

    override val serviceName: String
        get() = "Cloud9"
    /**
     * Cloud9Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): Cloud9Client {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultCloud9Client(config)
        }

        operator fun invoke(config: Config): Cloud9Client = DefaultCloud9Client(config)

        /**
         * Construct a [Cloud9Client] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): Cloud9Client {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return Cloud9Client(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and
     * then connects from the instance to the environment.
     */
    suspend fun createEnvironmentEc2(input: CreateEnvironmentEc2Request): CreateEnvironmentEc2Response

    /**
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and
     * then connects from the instance to the environment.
     */
    suspend fun createEnvironmentEc2(block: CreateEnvironmentEc2Request.DslBuilder.() -> Unit) = createEnvironmentEc2(CreateEnvironmentEc2Request.builder().apply(block).build())

    /**
     * Adds an environment member to an Cloud9 development environment.
     */
    suspend fun createEnvironmentMembership(input: CreateEnvironmentMembershipRequest): CreateEnvironmentMembershipResponse

    /**
     * Adds an environment member to an Cloud9 development environment.
     */
    suspend fun createEnvironmentMembership(block: CreateEnvironmentMembershipRequest.DslBuilder.() -> Unit) = createEnvironmentMembership(CreateEnvironmentMembershipRequest.builder().apply(block).build())

    /**
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the
     * environment, also terminates the instance.
     */
    suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the
     * environment, also terminates the instance.
     */
    suspend fun deleteEnvironment(block: DeleteEnvironmentRequest.DslBuilder.() -> Unit) = deleteEnvironment(DeleteEnvironmentRequest.builder().apply(block).build())

    /**
     * Deletes an environment member from an Cloud9 development environment.
     */
    suspend fun deleteEnvironmentMembership(input: DeleteEnvironmentMembershipRequest): DeleteEnvironmentMembershipResponse

    /**
     * Deletes an environment member from an Cloud9 development environment.
     */
    suspend fun deleteEnvironmentMembership(block: DeleteEnvironmentMembershipRequest.DslBuilder.() -> Unit) = deleteEnvironmentMembership(DeleteEnvironmentMembershipRequest.builder().apply(block).build())

    /**
     * Gets information about environment members for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentMemberships(input: DescribeEnvironmentMembershipsRequest): DescribeEnvironmentMembershipsResponse

    /**
     * Gets information about environment members for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentMemberships(block: DescribeEnvironmentMembershipsRequest.DslBuilder.() -> Unit) = describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest.builder().apply(block).build())

    /**
     * Gets status information for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentStatus(input: DescribeEnvironmentStatusRequest): DescribeEnvironmentStatusResponse

    /**
     * Gets status information for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentStatus(block: DescribeEnvironmentStatusRequest.DslBuilder.() -> Unit) = describeEnvironmentStatus(DescribeEnvironmentStatusRequest.builder().apply(block).build())

    /**
     * Gets information about Cloud9 development environments.
     */
    suspend fun describeEnvironments(input: DescribeEnvironmentsRequest): DescribeEnvironmentsResponse

    /**
     * Gets information about Cloud9 development environments.
     */
    suspend fun describeEnvironments(block: DescribeEnvironmentsRequest.DslBuilder.() -> Unit) = describeEnvironments(DescribeEnvironmentsRequest.builder().apply(block).build())

    /**
     * Gets a list of Cloud9 development environment identifiers.
     */
    suspend fun listEnvironments(input: ListEnvironmentsRequest): ListEnvironmentsResponse

    /**
     * Gets a list of Cloud9 development environment identifiers.
     */
    suspend fun listEnvironments(block: ListEnvironmentsRequest.DslBuilder.() -> Unit) = listEnvironments(ListEnvironmentsRequest.builder().apply(block).build())

    /**
     * Gets a list of the tags associated with an Cloud9 development environment.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a list of the tags associated with an Cloud9 development environment.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Adds tags to an Cloud9 development environment.
     * Tags that you add to an Cloud9 environment by using this method will NOT be
     * automatically propagated to underlying resources.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to an Cloud9 development environment.
     * Tags that you add to an Cloud9 environment by using this method will NOT be
     * automatically propagated to underlying resources.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes tags from an Cloud9 development environment.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from an Cloud9 development environment.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Changes the settings of an existing Cloud9 development environment.
     */
    suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Changes the settings of an existing Cloud9 development environment.
     */
    suspend fun updateEnvironment(block: UpdateEnvironmentRequest.DslBuilder.() -> Unit) = updateEnvironment(UpdateEnvironmentRequest.builder().apply(block).build())

    /**
     * Changes the settings of an existing environment member for an Cloud9 development
     * environment.
     */
    suspend fun updateEnvironmentMembership(input: UpdateEnvironmentMembershipRequest): UpdateEnvironmentMembershipResponse

    /**
     * Changes the settings of an existing environment member for an Cloud9 development
     * environment.
     */
    suspend fun updateEnvironmentMembership(block: UpdateEnvironmentMembershipRequest.DslBuilder.() -> Unit) = updateEnvironmentMembership(UpdateEnvironmentMembershipRequest.builder().apply(block).build())
}
