// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model



/**
 * Metadata that is associated with Amazon Web Services resources. In particular, a name-value pair that
 * can be associated with an Cloud9 development environment. There are two types of tags:
 * user tags and system tags. A user tag is created
 * by the user. A system tag is automatically created by Amazon Web Services services. A system tag is prefixed
 * with "aws:" and cannot be modified by the user.
 */
class Tag private constructor(builder: BuilderImpl) {
    /**
     * The name part of a tag.
     */
    val key: String? = builder.key
    /**
     * The value part of a tag.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Tag = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=*** Sensitive Data Redacted ***,")
        append("value=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Tag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Tag = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Tag
        /**
         * The name part of a tag.
         */
        fun key(key: String): FluentBuilder
        /**
         * The value part of a tag.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name part of a tag.
         */
        var key: String?
        /**
         * The value part of a tag.
         */
        var value: String?

        fun build(): Tag
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var key: String? = null
        override var value: String? = null

        constructor(x: Tag) : this() {
            this.key = x.key
            this.value = x.value
        }

        override fun build(): Tag = Tag(this)
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
