// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model



class CreateEnvironmentEc2Request private constructor(builder: BuilderImpl) {
    /**
     * The number of minutes until the running instance is shut down after the environment has
     * last been used.
     */
    val automaticStopTimeMinutes: Int? = builder.automaticStopTimeMinutes
    /**
     * A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no
     * more than one time.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens in the
     * Amazon EC2 API Reference.
     */
    val clientRequestToken: String? = builder.clientRequestToken
    /**
     * The connection type used for connecting to an Amazon EC2 environment. Valid values are
     * CONNECT_SSH (default) and CONNECT_SSM (connected through
     * Amazon EC2 Systems Manager).
     * For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with
     * Amazon EC2 Systems Manager in the Cloud9 User Guide.
     */
    val connectionType: ConnectionType? = builder.connectionType
    /**
     * The description of the environment to create.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance.
     * To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM)
     * path.
     * The default AMI is used if the parameter isn't explicitly assigned a value in the request.
     * Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you
     * choose Amazon Linux 2, which includes long term support through 2023.
     * AMI aliases
     * Amazon Linux (default):
     * amazonlinux-1-x86_64
     * Amazon Linux 2: amazonlinux-2-x86_64
     * Ubuntu 18.04: ubuntu-18.04-x86_64
     * SSM paths
     * Amazon Linux (default):
     * resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64
     * Amazon Linux 2:
     * resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64
     * Ubuntu 18.04:
     * resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64
     */
    val imageId: String? = builder.imageId
    /**
     * The type of instance to connect to the environment (for example,
     * t2.micro).
     */
    val instanceType: String? = builder.instanceType
    /**
     * The name of the environment to create.
     * This name is visible to other IAM users in the same Amazon Web Services account.
     */
    val name: String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any
     * IAM principal. If this value is not specified, the ARN defaults to this environment's
     * creator.
     */
    val ownerArn: String? = builder.ownerArn
    /**
     * The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2
     * instance.
     */
    val subnetId: String? = builder.subnetId
    /**
     * An array of key-value pairs that will be associated with the new Cloud9 development
     * environment.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateEnvironmentEc2Request = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentEc2Request(")
        append("automaticStopTimeMinutes=$automaticStopTimeMinutes,")
        append("clientRequestToken=$clientRequestToken,")
        append("connectionType=$connectionType,")
        append("description=*** Sensitive Data Redacted ***,")
        append("dryRun=$dryRun,")
        append("imageId=$imageId,")
        append("instanceType=$instanceType,")
        append("name=$name,")
        append("ownerArn=$ownerArn,")
        append("subnetId=$subnetId,")
        append("tags=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = automaticStopTimeMinutes ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateEnvironmentEc2Request

        if (automaticStopTimeMinutes != other.automaticStopTimeMinutes) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (connectionType != other.connectionType) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (imageId != other.imageId) return false
        if (instanceType != other.instanceType) return false
        if (name != other.name) return false
        if (ownerArn != other.ownerArn) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateEnvironmentEc2Request = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateEnvironmentEc2Request
        /**
         * The number of minutes until the running instance is shut down after the environment has
         * last been used.
         */
        fun automaticStopTimeMinutes(automaticStopTimeMinutes: Int): FluentBuilder
        /**
         * A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no
         * more than one time.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens in the
         * Amazon EC2 API Reference.
         */
        fun clientRequestToken(clientRequestToken: String): FluentBuilder
        /**
         * The connection type used for connecting to an Amazon EC2 environment. Valid values are
         * CONNECT_SSH (default) and CONNECT_SSM (connected through
         * Amazon EC2 Systems Manager).
         * For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with
         * Amazon EC2 Systems Manager in the Cloud9 User Guide.
         */
        fun connectionType(connectionType: ConnectionType): FluentBuilder
        /**
         * The description of the environment to create.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance.
         * To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM)
         * path.
         * The default AMI is used if the parameter isn't explicitly assigned a value in the request.
         * Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you
         * choose Amazon Linux 2, which includes long term support through 2023.
         * AMI aliases
         * Amazon Linux (default):
         * amazonlinux-1-x86_64
         * Amazon Linux 2: amazonlinux-2-x86_64
         * Ubuntu 18.04: ubuntu-18.04-x86_64
         * SSM paths
         * Amazon Linux (default):
         * resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64
         * Amazon Linux 2:
         * resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64
         * Ubuntu 18.04:
         * resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The type of instance to connect to the environment (for example,
         * t2.micro).
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The name of the environment to create.
         * This name is visible to other IAM users in the same Amazon Web Services account.
         */
        fun name(name: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any
         * IAM principal. If this value is not specified, the ARN defaults to this environment's
         * creator.
         */
        fun ownerArn(ownerArn: String): FluentBuilder
        /**
         * The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2
         * instance.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * An array of key-value pairs that will be associated with the new Cloud9 development
         * environment.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of minutes until the running instance is shut down after the environment has
         * last been used.
         */
        var automaticStopTimeMinutes: Int?
        /**
         * A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no
         * more than one time.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens in the
         * Amazon EC2 API Reference.
         */
        var clientRequestToken: String?
        /**
         * The connection type used for connecting to an Amazon EC2 environment. Valid values are
         * CONNECT_SSH (default) and CONNECT_SSM (connected through
         * Amazon EC2 Systems Manager).
         * For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances with
         * Amazon EC2 Systems Manager in the Cloud9 User Guide.
         */
        var connectionType: ConnectionType?
        /**
         * The description of the environment to create.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance.
         * To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM)
         * path.
         * The default AMI is used if the parameter isn't explicitly assigned a value in the request.
         * Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you
         * choose Amazon Linux 2, which includes long term support through 2023.
         * AMI aliases
         * Amazon Linux (default):
         * amazonlinux-1-x86_64
         * Amazon Linux 2: amazonlinux-2-x86_64
         * Ubuntu 18.04: ubuntu-18.04-x86_64
         * SSM paths
         * Amazon Linux (default):
         * resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64
         * Amazon Linux 2:
         * resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64
         * Ubuntu 18.04:
         * resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64
         */
        var imageId: String?
        /**
         * The type of instance to connect to the environment (for example,
         * t2.micro).
         */
        var instanceType: String?
        /**
         * The name of the environment to create.
         * This name is visible to other IAM users in the same Amazon Web Services account.
         */
        var name: String?
        /**
         * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any
         * IAM principal. If this value is not specified, the ARN defaults to this environment's
         * creator.
         */
        var ownerArn: String?
        /**
         * The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2
         * instance.
         */
        var subnetId: String?
        /**
         * An array of key-value pairs that will be associated with the new Cloud9 development
         * environment.
         */
        var tags: List<Tag>?

        fun build(): CreateEnvironmentEc2Request
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var automaticStopTimeMinutes: Int? = null
        override var clientRequestToken: String? = null
        override var connectionType: ConnectionType? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var imageId: String? = null
        override var instanceType: String? = null
        override var name: String? = null
        override var ownerArn: String? = null
        override var subnetId: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateEnvironmentEc2Request) : this() {
            this.automaticStopTimeMinutes = x.automaticStopTimeMinutes
            this.clientRequestToken = x.clientRequestToken
            this.connectionType = x.connectionType
            this.description = x.description
            this.dryRun = x.dryRun
            this.imageId = x.imageId
            this.instanceType = x.instanceType
            this.name = x.name
            this.ownerArn = x.ownerArn
            this.subnetId = x.subnetId
            this.tags = x.tags
        }

        override fun build(): CreateEnvironmentEc2Request = CreateEnvironmentEc2Request(this)
        override fun automaticStopTimeMinutes(automaticStopTimeMinutes: Int): FluentBuilder = apply { this.automaticStopTimeMinutes = automaticStopTimeMinutes }
        override fun clientRequestToken(clientRequestToken: String): FluentBuilder = apply { this.clientRequestToken = clientRequestToken }
        override fun connectionType(connectionType: ConnectionType): FluentBuilder = apply { this.connectionType = connectionType }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun ownerArn(ownerArn: String): FluentBuilder = apply { this.ownerArn = ownerArn }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
