// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model



/**
 * Information about an AWS Cloud9 development environment.
 */
class Environment private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    val arn: String? = builder.arn
    /**
     * The connection type used for connecting to an Amazon EC2 environment. CONNECT_SSH is selected by default.
     */
    val connectionType: ConnectionType? = builder.connectionType
    /**
     * The description for the environment.
     */
    val description: String? = builder.description
    /**
     * The ID of the environment.
     */
    val id: String? = builder.id
    /**
     * The state of the environment in its creation or deletion lifecycle.
     */
    val lifecycle: EnvironmentLifecycle? = builder.lifecycle
    /**
     * Describes the status of AWS managed temporary credentials for the AWS Cloud9 environment. Available values
     * are:
     * ENABLED_ON_CREATE
     * ENABLED_BY_OWNER
     * DISABLED_BY_DEFAULT
     * DISABLED_BY_OWNER
     * DISABLED_BY_COLLABORATOR
     * PENDING_REMOVAL_BY_COLLABORATOR
     * PENDING_REMOVAL_BY_OWNER
     * FAILED_REMOVAL_BY_COLLABORATOR
     * ENABLED_BY_OWNER
     * DISABLED_BY_DEFAULT
     */
    val managedCredentialsStatus: ManagedCredentialsStatus? = builder.managedCredentialsStatus
    /**
     * The name of the environment.
     */
    val name: String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the environment owner.
     */
    val ownerArn: String? = builder.ownerArn
    /**
     * The type of environment. Valid values include the following:
     * ec2: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     * ssh: Your own server connects to the environment.
     */
    val type: EnvironmentType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Environment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Environment(")
        append("arn=$arn,")
        append("connectionType=$connectionType,")
        append("description=*** Sensitive Data Redacted ***,")
        append("id=$id,")
        append("lifecycle=$lifecycle,")
        append("managedCredentialsStatus=$managedCredentialsStatus,")
        append("name=$name,")
        append("ownerArn=$ownerArn,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (managedCredentialsStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Environment

        if (arn != other.arn) return false
        if (connectionType != other.connectionType) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lifecycle != other.lifecycle) return false
        if (managedCredentialsStatus != other.managedCredentialsStatus) return false
        if (name != other.name) return false
        if (ownerArn != other.ownerArn) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Environment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Environment
        /**
         * The Amazon Resource Name (ARN) of the environment.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The connection type used for connecting to an Amazon EC2 environment. CONNECT_SSH is selected by default.
         */
        fun connectionType(connectionType: ConnectionType): FluentBuilder
        /**
         * The description for the environment.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the environment.
         */
        fun id(id: String): FluentBuilder
        /**
         * The state of the environment in its creation or deletion lifecycle.
         */
        fun lifecycle(lifecycle: EnvironmentLifecycle): FluentBuilder
        /**
         * Describes the status of AWS managed temporary credentials for the AWS Cloud9 environment. Available values
         * are:
         * ENABLED_ON_CREATE
         * ENABLED_BY_OWNER
         * DISABLED_BY_DEFAULT
         * DISABLED_BY_OWNER
         * DISABLED_BY_COLLABORATOR
         * PENDING_REMOVAL_BY_COLLABORATOR
         * PENDING_REMOVAL_BY_OWNER
         * FAILED_REMOVAL_BY_COLLABORATOR
         * ENABLED_BY_OWNER
         * DISABLED_BY_DEFAULT
         */
        fun managedCredentialsStatus(managedCredentialsStatus: ManagedCredentialsStatus): FluentBuilder
        /**
         * The name of the environment.
         */
        fun name(name: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the environment owner.
         */
        fun ownerArn(ownerArn: String): FluentBuilder
        /**
         * The type of environment. Valid values include the following:
         * ec2: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         * ssh: Your own server connects to the environment.
         */
        fun type(type: EnvironmentType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the environment.
         */
        var arn: String?
        /**
         * The connection type used for connecting to an Amazon EC2 environment. CONNECT_SSH is selected by default.
         */
        var connectionType: ConnectionType?
        /**
         * The description for the environment.
         */
        var description: String?
        /**
         * The ID of the environment.
         */
        var id: String?
        /**
         * The state of the environment in its creation or deletion lifecycle.
         */
        var lifecycle: EnvironmentLifecycle?
        /**
         * Describes the status of AWS managed temporary credentials for the AWS Cloud9 environment. Available values
         * are:
         * ENABLED_ON_CREATE
         * ENABLED_BY_OWNER
         * DISABLED_BY_DEFAULT
         * DISABLED_BY_OWNER
         * DISABLED_BY_COLLABORATOR
         * PENDING_REMOVAL_BY_COLLABORATOR
         * PENDING_REMOVAL_BY_OWNER
         * FAILED_REMOVAL_BY_COLLABORATOR
         * ENABLED_BY_OWNER
         * DISABLED_BY_DEFAULT
         */
        var managedCredentialsStatus: ManagedCredentialsStatus?
        /**
         * The name of the environment.
         */
        var name: String?
        /**
         * The Amazon Resource Name (ARN) of the environment owner.
         */
        var ownerArn: String?
        /**
         * The type of environment. Valid values include the following:
         * ec2: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         * ssh: Your own server connects to the environment.
         */
        var type: EnvironmentType?

        fun build(): Environment
        /**
         * construct an [aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle] inside the given [block]
         */
        fun lifecycle(block: EnvironmentLifecycle.DslBuilder.() -> kotlin.Unit) {
            this.lifecycle = EnvironmentLifecycle.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var connectionType: ConnectionType? = null
        override var description: String? = null
        override var id: String? = null
        override var lifecycle: EnvironmentLifecycle? = null
        override var managedCredentialsStatus: ManagedCredentialsStatus? = null
        override var name: String? = null
        override var ownerArn: String? = null
        override var type: EnvironmentType? = null

        constructor(x: Environment) : this() {
            this.arn = x.arn
            this.connectionType = x.connectionType
            this.description = x.description
            this.id = x.id
            this.lifecycle = x.lifecycle
            this.managedCredentialsStatus = x.managedCredentialsStatus
            this.name = x.name
            this.ownerArn = x.ownerArn
            this.type = x.type
        }

        override fun build(): Environment = Environment(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun connectionType(connectionType: ConnectionType): FluentBuilder = apply { this.connectionType = connectionType }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lifecycle(lifecycle: EnvironmentLifecycle): FluentBuilder = apply { this.lifecycle = lifecycle }
        override fun managedCredentialsStatus(managedCredentialsStatus: ManagedCredentialsStatus): FluentBuilder = apply { this.managedCredentialsStatus = managedCredentialsStatus }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun ownerArn(ownerArn: String): FluentBuilder = apply { this.ownerArn = ownerArn }
        override fun type(type: EnvironmentType): FluentBuilder = apply { this.type = type }
    }
}
