// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model



class DescribeEnvironmentMembershipsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the environment to get environment member information about.
     */
    val environmentId: String? = builder.environmentId
    /**
     * The maximum number of environment members to get information about.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a next token. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The type of environment member permissions to get information about. Available values include:
     * owner: Owns the environment.
     * read-only: Has read-only access to the environment.
     * read-write: Has read-write access to the environment.
     * If no value is specified, information about all environment members are returned.
     */
    val permissions: List<Permissions>? = builder.permissions
    /**
     * The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.
     */
    val userArn: String? = builder.userArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeEnvironmentMembershipsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEnvironmentMembershipsRequest(")
        append("environmentId=$environmentId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("permissions=$permissions,")
        append("userArn=$userArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (userArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeEnvironmentMembershipsRequest

        if (environmentId != other.environmentId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (permissions != other.permissions) return false
        if (userArn != other.userArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeEnvironmentMembershipsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeEnvironmentMembershipsRequest
        /**
         * The ID of the environment to get environment member information about.
         */
        fun environmentId(environmentId: String): FluentBuilder
        /**
         * The maximum number of environment members to get information about.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a next token. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The type of environment member permissions to get information about. Available values include:
         * owner: Owns the environment.
         * read-only: Has read-only access to the environment.
         * read-write: Has read-write access to the environment.
         * If no value is specified, information about all environment members are returned.
         */
        fun permissions(permissions: List<Permissions>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.
         */
        fun userArn(userArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the environment to get environment member information about.
         */
        var environmentId: String?
        /**
         * The maximum number of environment members to get information about.
         */
        var maxResults: Int?
        /**
         * During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a next token. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
         */
        var nextToken: String?
        /**
         * The type of environment member permissions to get information about. Available values include:
         * owner: Owns the environment.
         * read-only: Has read-only access to the environment.
         * read-write: Has read-write access to the environment.
         * If no value is specified, information about all environment members are returned.
         */
        var permissions: List<Permissions>?
        /**
         * The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.
         */
        var userArn: String?

        fun build(): DescribeEnvironmentMembershipsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var environmentId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var permissions: List<Permissions>? = null
        override var userArn: String? = null

        constructor(x: DescribeEnvironmentMembershipsRequest) : this() {
            this.environmentId = x.environmentId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.permissions = x.permissions
            this.userArn = x.userArn
        }

        override fun build(): DescribeEnvironmentMembershipsRequest = DescribeEnvironmentMembershipsRequest(this)
        override fun environmentId(environmentId: String): FluentBuilder = apply { this.environmentId = environmentId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun permissions(permissions: List<Permissions>): FluentBuilder = apply { this.permissions = permissions }
        override fun userArn(userArn: String): FluentBuilder = apply { this.userArn = userArn }
    }
}
