// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesCloud9ModelEnvironmentLifecycleDslBuilderRef = aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle

/**
 * Information about an Cloud9 development environment.
 */
public class Environment private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The connection type used for connecting to an Amazon EC2 environment. `CONNECT_SSH` is selected by default.
     */
    public val connectionType: aws.sdk.kotlin.services.cloud9.model.ConnectionType? = builder.connectionType
    /**
     * The description for the environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the environment.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The state of the environment in its creation or deletion lifecycle.
     */
    public val lifecycle: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle? = builder.lifecycle
    /**
     * Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment. Available values are:
     * + `ENABLED_ON_CREATE`
     * + `ENABLED_BY_OWNER`
     * + `DISABLED_BY_DEFAULT`
     * + `DISABLED_BY_OWNER`
     * + `DISABLED_BY_COLLABORATOR`
     * + `PENDING_REMOVAL_BY_COLLABORATOR`
     * + `PENDING_REMOVAL_BY_OWNER`
     * + `FAILED_REMOVAL_BY_COLLABORATOR`
     * + `ENABLED_BY_OWNER`
     * + `DISABLED_BY_DEFAULT`
     */
    public val managedCredentialsStatus: aws.sdk.kotlin.services.cloud9.model.ManagedCredentialsStatus? = builder.managedCredentialsStatus
    /**
     * The name of the environment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the environment owner.
     */
    public val ownerArn: kotlin.String = requireNotNull(builder.ownerArn) { "A non-null value must be provided for ownerArn" }
    /**
     * The type of environment. Valid values include the following:
     * + `ec2`: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     * + `ssh`: Your own server connects to the environment.
     */
    public val type: aws.sdk.kotlin.services.cloud9.model.EnvironmentType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloud9.model.Environment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Environment(")
        append("arn=$arn,")
        append("connectionType=$connectionType,")
        append("description=*** Sensitive Data Redacted ***,")
        append("id=$id,")
        append("lifecycle=$lifecycle,")
        append("managedCredentialsStatus=$managedCredentialsStatus,")
        append("name=$name,")
        append("ownerArn=$ownerArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (this.connectionType?.hashCode() ?: 0)
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.id?.hashCode() ?: 0)
        result = 31 * result + (this.lifecycle?.hashCode() ?: 0)
        result = 31 * result + (this.managedCredentialsStatus?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.ownerArn.hashCode())
        result = 31 * result + (this.type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Environment

        if (arn != other.arn) return false
        if (connectionType != other.connectionType) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lifecycle != other.lifecycle) return false
        if (managedCredentialsStatus != other.managedCredentialsStatus) return false
        if (name != other.name) return false
        if (ownerArn != other.ownerArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloud9.model.Environment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the environment.
         */
        public var arn: kotlin.String? = null
        /**
         * The connection type used for connecting to an Amazon EC2 environment. `CONNECT_SSH` is selected by default.
         */
        public var connectionType: aws.sdk.kotlin.services.cloud9.model.ConnectionType? = null
        /**
         * The description for the environment.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the environment.
         */
        public var id: kotlin.String? = null
        /**
         * The state of the environment in its creation or deletion lifecycle.
         */
        public var lifecycle: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle? = null
        /**
         * Describes the status of Amazon Web Services managed temporary credentials for the Cloud9 environment. Available values are:
         * + `ENABLED_ON_CREATE`
         * + `ENABLED_BY_OWNER`
         * + `DISABLED_BY_DEFAULT`
         * + `DISABLED_BY_OWNER`
         * + `DISABLED_BY_COLLABORATOR`
         * + `PENDING_REMOVAL_BY_COLLABORATOR`
         * + `PENDING_REMOVAL_BY_OWNER`
         * + `FAILED_REMOVAL_BY_COLLABORATOR`
         * + `ENABLED_BY_OWNER`
         * + `DISABLED_BY_DEFAULT`
         */
        public var managedCredentialsStatus: aws.sdk.kotlin.services.cloud9.model.ManagedCredentialsStatus? = null
        /**
         * The name of the environment.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the environment owner.
         */
        public var ownerArn: kotlin.String? = null
        /**
         * The type of environment. Valid values include the following:
         * + `ec2`: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         * + `ssh`: Your own server connects to the environment.
         */
        public var type: aws.sdk.kotlin.services.cloud9.model.EnvironmentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloud9.model.Environment) : this() {
            this.arn = x.arn
            this.connectionType = x.connectionType
            this.description = x.description
            this.id = x.id
            this.lifecycle = x.lifecycle
            this.managedCredentialsStatus = x.managedCredentialsStatus
            this.name = x.name
            this.ownerArn = x.ownerArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloud9.model.Environment = Environment(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = awsSdkKotlinServicesCloud9ModelEnvironmentLifecycleDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (ownerArn == null) ownerArn = ""
            if (type == null) type = EnvironmentType.SdkUnknown("no value provided")
            return this
        }
    }
}
