// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


/**
 * Information about an environment member for an Cloud9 development environment.
 */
public class EnvironmentMember private constructor(builder: Builder) {
    /**
     * The ID of the environment for the environment member.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }
    /**
     * The time, expressed in epoch time format, when the environment member last opened the environment.
     */
    public val lastAccess: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccess
    /**
     * The type of environment member permissions associated with this environment member. Available values include:
     * + `owner`: Owns the environment.
     * + `read-only`: Has read-only access to the environment.
     * + `read-write`: Has read-write access to the environment.
     */
    public val permissions: aws.sdk.kotlin.services.cloud9.model.Permissions = requireNotNull(builder.permissions) { "A non-null value must be provided for permissions" }
    /**
     * The Amazon Resource Name (ARN) of the environment member.
     */
    public val userArn: kotlin.String = requireNotNull(builder.userArn) { "A non-null value must be provided for userArn" }
    /**
     * The user ID in Identity and Access Management (IAM) of the environment member.
     */
    public val userId: kotlin.String = requireNotNull(builder.userId) { "A non-null value must be provided for userId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloud9.model.EnvironmentMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentMember(")
        append("environmentId=$environmentId,")
        append("lastAccess=$lastAccess,")
        append("permissions=$permissions,")
        append("userArn=$userArn,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentId.hashCode()
        result = 31 * result + (this.lastAccess?.hashCode() ?: 0)
        result = 31 * result + (this.permissions.hashCode())
        result = 31 * result + (this.userArn.hashCode())
        result = 31 * result + (this.userId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentMember

        if (environmentId != other.environmentId) return false
        if (lastAccess != other.lastAccess) return false
        if (permissions != other.permissions) return false
        if (userArn != other.userArn) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloud9.model.EnvironmentMember = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the environment for the environment member.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The time, expressed in epoch time format, when the environment member last opened the environment.
         */
        public var lastAccess: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of environment member permissions associated with this environment member. Available values include:
         * + `owner`: Owns the environment.
         * + `read-only`: Has read-only access to the environment.
         * + `read-write`: Has read-write access to the environment.
         */
        public var permissions: aws.sdk.kotlin.services.cloud9.model.Permissions? = null
        /**
         * The Amazon Resource Name (ARN) of the environment member.
         */
        public var userArn: kotlin.String? = null
        /**
         * The user ID in Identity and Access Management (IAM) of the environment member.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloud9.model.EnvironmentMember) : this() {
            this.environmentId = x.environmentId
            this.lastAccess = x.lastAccess
            this.permissions = x.permissions
            this.userArn = x.userArn
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloud9.model.EnvironmentMember = EnvironmentMember(this)

        internal fun correctErrors(): Builder {
            if (environmentId == null) environmentId = ""
            if (permissions == null) permissions = Permissions.SdkUnknown("no value provided")
            if (userArn == null) userArn = ""
            if (userId == null) userId = ""
            return this
        }
    }
}
