// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Information about the current creation or deletion lifecycle state of an Cloud9 development environment.
 */
public class EnvironmentLifecycle private constructor(builder: Builder) {
    /**
     * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services resource.
     */
    public val failureResource: kotlin.String? = builder.failureResource
    /**
     * Any informational message about the lifecycle state of the environment.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The current creation or deletion lifecycle state of the environment.
     * + `CREATING`: The environment is in the process of being created.
     * + `CREATED`: The environment was successfully created.
     * + `CREATE_FAILED`: The environment failed to be created.
     * + `DELETING`: The environment is in the process of being deleted.
     * + `DELETE_FAILED`: The environment failed to delete.
     */
    public val status: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycleStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentLifecycle(")
        append("failureResource=$failureResource,")
        append("reason=$reason,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureResource?.hashCode() ?: 0
        result = 31 * result + (this.reason?.hashCode() ?: 0)
        result = 31 * result + (this.status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentLifecycle

        if (failureResource != other.failureResource) return false
        if (reason != other.reason) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services resource.
         */
        public var failureResource: kotlin.String? = null
        /**
         * Any informational message about the lifecycle state of the environment.
         */
        public var reason: kotlin.String? = null
        /**
         * The current creation or deletion lifecycle state of the environment.
         * + `CREATING`: The environment is in the process of being created.
         * + `CREATED`: The environment was successfully created.
         * + `CREATE_FAILED`: The environment failed to be created.
         * + `DELETING`: The environment is in the process of being deleted.
         * + `DELETE_FAILED`: The environment failed to delete.
         */
        public var status: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycleStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle) : this() {
            this.failureResource = x.failureResource
            this.reason = x.reason
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle = EnvironmentLifecycle(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
