// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloud9.auth.Cloud9AuthSchemeProvider
import aws.sdk.kotlin.services.cloud9.auth.DefaultCloud9AuthSchemeProvider
import aws.sdk.kotlin.services.cloud9.endpoints.Cloud9EndpointParameters
import aws.sdk.kotlin.services.cloud9.endpoints.Cloud9EndpointProvider
import aws.sdk.kotlin.services.cloud9.endpoints.DefaultCloud9EndpointProvider
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Request
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Response
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentMembershipRequest
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentMembershipResponse
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentMembershipRequest
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentMembershipResponse
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsRequest
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsResponse
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentStatusRequest
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentStatusResponse
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentsRequest
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentsResponse
import aws.sdk.kotlin.services.cloud9.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.cloud9.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.cloud9.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cloud9.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cloud9.model.TagResourceRequest
import aws.sdk.kotlin.services.cloud9.model.TagResourceResponse
import aws.sdk.kotlin.services.cloud9.model.UntagResourceRequest
import aws.sdk.kotlin.services.cloud9.model.UntagResourceResponse
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentMembershipRequest
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentMembershipResponse
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Cloud9"
public const val SdkVersion: String = "1.5.27"
public const val ServiceApiVersion: String = "2017-09-23"

/**
 * # Cloud9
 * Cloud9 is a collection of tools that you can use to code, build, run, test, debug, and release software in the cloud.
 *
 * For more information about Cloud9, see the [Cloud9 User Guide](https://docs.aws.amazon.com/cloud9/latest/user-guide).
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * Cloud9 supports these operations:
 * + `CreateEnvironmentEC2`: Creates an Cloud9 development environment, launches an Amazon EC2 instance, and then connects from the instance to the environment.
 * + `CreateEnvironmentMembership`: Adds an environment member to an environment.
 * + `DeleteEnvironment`: Deletes an environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
 * + `DeleteEnvironmentMembership`: Deletes an environment member from an environment.
 * + `DescribeEnvironmentMemberships`: Gets information about environment members for an environment.
 * + `DescribeEnvironments`: Gets information about environments.
 * + `DescribeEnvironmentStatus`: Gets status information for an environment.
 * + `ListEnvironments`: Gets a list of environment identifiers.
 * + `ListTagsForResource`: Gets the tags for an environment.
 * + `TagResource`: Adds tags to an environment.
 * + `UntagResource`: Removes tags from an environment.
 * + `UpdateEnvironment`: Changes the settings of an existing environment.
 * + `UpdateEnvironmentMembership`: Changes the settings of an existing environment member for an environment.
 */
public interface Cloud9Client : SdkClient {
    /**
     * Cloud9Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, Cloud9Client, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Cloud9",
                "CLOUD9",
                "cloud9",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, Cloud9Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): Cloud9Client = DefaultCloud9Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: Cloud9EndpointProvider = builder.endpointProvider ?: DefaultCloud9EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: Cloud9AuthSchemeProvider = builder.authSchemeProvider ?: DefaultCloud9AuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Cloud9"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: Cloud9EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: Cloud9AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.CreateEnvironmentEC2.sample
     */
    public suspend fun createEnvironmentEc2(input: CreateEnvironmentEc2Request): CreateEnvironmentEc2Response

    /**
     * Adds an environment member to an Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.CreateEnvironmentMembership.sample
     */
    public suspend fun createEnvironmentMembership(input: CreateEnvironmentMembershipRequest): CreateEnvironmentMembershipResponse

    /**
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.DeleteEnvironment.sample
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes an environment member from a development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.DeleteEnvironmentMembership.sample
     */
    public suspend fun deleteEnvironmentMembership(input: DeleteEnvironmentMembershipRequest): DeleteEnvironmentMembershipResponse

    /**
     * Gets information about environment members for an Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentMemberships.sample
     * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentMemberships.sample2
     * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentMemberships.sample3
     */
    public suspend fun describeEnvironmentMemberships(input: DescribeEnvironmentMembershipsRequest = DescribeEnvironmentMembershipsRequest { }): DescribeEnvironmentMembershipsResponse

    /**
     * Gets status information for an Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentStatus.sample
     */
    public suspend fun describeEnvironmentStatus(input: DescribeEnvironmentStatusRequest): DescribeEnvironmentStatusResponse

    /**
     * Gets information about Cloud9 development environments.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironments.sample
     */
    public suspend fun describeEnvironments(input: DescribeEnvironmentsRequest): DescribeEnvironmentsResponse

    /**
     * Gets a list of Cloud9 development environment identifiers.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.ListEnvironments.sample
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest { }): ListEnvironmentsResponse

    /**
     * Gets a list of the tags associated with an Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds tags to an Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to underlying resources.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Changes the settings of an existing Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.UpdateEnvironment.sample
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Changes the settings of an existing environment member for an Cloud9 development environment.
     *
     * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
     *
     * @sample aws.sdk.kotlin.services.cloud9.samples.UpdateEnvironmentMembership.sample
     */
    public suspend fun updateEnvironmentMembership(input: UpdateEnvironmentMembershipRequest): UpdateEnvironmentMembershipResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun Cloud9Client.withConfig(block: Cloud9Client.Config.Builder.() -> Unit): Cloud9Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCloud9Client(newConfig)
}

/**
 * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.CreateEnvironmentEC2.sample
 */
public suspend inline fun Cloud9Client.createEnvironmentEc2(crossinline block: CreateEnvironmentEc2Request.Builder.() -> Unit): CreateEnvironmentEc2Response = createEnvironmentEc2(CreateEnvironmentEc2Request.Builder().apply(block).build())

/**
 * Adds an environment member to an Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.CreateEnvironmentMembership.sample
 */
public suspend inline fun Cloud9Client.createEnvironmentMembership(crossinline block: CreateEnvironmentMembershipRequest.Builder.() -> Unit): CreateEnvironmentMembershipResponse = createEnvironmentMembership(CreateEnvironmentMembershipRequest.Builder().apply(block).build())

/**
 * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.DeleteEnvironment.sample
 */
public suspend inline fun Cloud9Client.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes an environment member from a development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.DeleteEnvironmentMembership.sample
 */
public suspend inline fun Cloud9Client.deleteEnvironmentMembership(crossinline block: DeleteEnvironmentMembershipRequest.Builder.() -> Unit): DeleteEnvironmentMembershipResponse = deleteEnvironmentMembership(DeleteEnvironmentMembershipRequest.Builder().apply(block).build())

/**
 * Gets information about environment members for an Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentMemberships.sample
 * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentMemberships.sample2
 * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentMemberships.sample3
 */
public suspend inline fun Cloud9Client.describeEnvironmentMemberships(crossinline block: DescribeEnvironmentMembershipsRequest.Builder.() -> Unit): DescribeEnvironmentMembershipsResponse = describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest.Builder().apply(block).build())

/**
 * Gets status information for an Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironmentStatus.sample
 */
public suspend inline fun Cloud9Client.describeEnvironmentStatus(crossinline block: DescribeEnvironmentStatusRequest.Builder.() -> Unit): DescribeEnvironmentStatusResponse = describeEnvironmentStatus(DescribeEnvironmentStatusRequest.Builder().apply(block).build())

/**
 * Gets information about Cloud9 development environments.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.DescribeEnvironments.sample
 */
public suspend inline fun Cloud9Client.describeEnvironments(crossinline block: DescribeEnvironmentsRequest.Builder.() -> Unit): DescribeEnvironmentsResponse = describeEnvironments(DescribeEnvironmentsRequest.Builder().apply(block).build())

/**
 * Gets a list of Cloud9 development environment identifiers.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.ListEnvironments.sample
 */
public suspend inline fun Cloud9Client.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Gets a list of the tags associated with an Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 */
public suspend inline fun Cloud9Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds tags to an Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to underlying resources.
 */
public suspend inline fun Cloud9Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 */
public suspend inline fun Cloud9Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Changes the settings of an existing Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.UpdateEnvironment.sample
 */
public suspend inline fun Cloud9Client.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

/**
 * Changes the settings of an existing environment member for an Cloud9 development environment.
 *
 * Cloud9 is no longer available to new customers. Existing customers of Cloud9 can continue to use the service as normal. [Learn more"](http://aws.amazon.com/blogs/devops/how-to-migrate-from-aws-cloud9-to-aws-ide-toolkits-or-aws-cloudshell/)
 *
 * @sample aws.sdk.kotlin.services.cloud9.samples.UpdateEnvironmentMembership.sample
 */
public suspend inline fun Cloud9Client.updateEnvironmentMembership(crossinline block: UpdateEnvironmentMembershipRequest.Builder.() -> Unit): UpdateEnvironmentMembershipResponse = updateEnvironmentMembership(UpdateEnvironmentMembershipRequest.Builder().apply(block).build())
