// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateEnvironmentEc2Request private constructor(builder: Builder) {
    /**
     * The number of minutes until the running instance is shut down after the environment has last been used.
     */
    public val automaticStopTimeMinutes: kotlin.Int? = builder.automaticStopTimeMinutes
    /**
     * A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no more than one time.
     *
     * For more information, see [Client Tokens](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The connection type used for connecting to an Amazon EC2 environment. Valid values are `CONNECT_SSH` (default) and `CONNECT_SSM` (connected through Amazon EC2 Systems Manager).
     *
     * For more information, see [Accessing no-ingress EC2 instances with Amazon EC2 Systems Manager](https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html) in the *Cloud9 User Guide*.
     */
    public val connectionType: aws.sdk.kotlin.services.cloud9.model.ConnectionType? = builder.connectionType
    /**
     * The description of the environment to create.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path.
     *
     * From December 04, 2023, you will be required to include the `imageId` parameter for the `CreateEnvironmentEC2` action. This change will be reflected across all direct methods of communicating with the API, such as Amazon Web Services SDK, Amazon Web Services CLI and Amazon Web Services CloudFormation. This change will only affect direct API consumers, and not Cloud9 console users.
     *
     * We recommend using Amazon Linux 2023 as the AMI to create your environment as it is fully supported.
     *
     * Since Ubuntu 18.04 has ended standard support as of May 31, 2023, we recommend you choose Ubuntu 22.04.
     *
     * **AMI aliases **
     * + Amazon Linux 2: `amazonlinux-2-x86_64`
     * + Amazon Linux 2023 (recommended): `amazonlinux-2023-x86_64`
     * + Ubuntu 18.04: `ubuntu-18.04-x86_64`
     * + Ubuntu 22.04: `ubuntu-22.04-x86_64`
     *
     * **SSM paths**
     * + Amazon Linux 2: `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64`
     * + Amazon Linux 2023 (recommended): `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2023-x86_64`
     * + Ubuntu 18.04: `resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64`
     * + Ubuntu 22.04: `resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64`
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The type of instance to connect to the environment (for example, `t2.micro`).
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The name of the environment to create.
     *
     * This name is visible to other IAM users in the same Amazon Web Services account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any IAM principal. If this value is not specified, the ARN defaults to this environment's creator.
     */
    public val ownerArn: kotlin.String? = builder.ownerArn
    /**
     * The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2 instance.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * An array of key-value pairs that will be associated with the new Cloud9 development environment.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentEc2Request(")
        append("automaticStopTimeMinutes=$automaticStopTimeMinutes,")
        append("clientRequestToken=$clientRequestToken,")
        append("connectionType=$connectionType,")
        append("description=*** Sensitive Data Redacted ***,")
        append("dryRun=$dryRun,")
        append("imageId=$imageId,")
        append("instanceType=$instanceType,")
        append("name=$name,")
        append("ownerArn=$ownerArn,")
        append("subnetId=$subnetId,")
        append("tags=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = automaticStopTimeMinutes ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEnvironmentEc2Request

        if (automaticStopTimeMinutes != other.automaticStopTimeMinutes) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (connectionType != other.connectionType) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (imageId != other.imageId) return false
        if (instanceType != other.instanceType) return false
        if (name != other.name) return false
        if (ownerArn != other.ownerArn) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Request = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of minutes until the running instance is shut down after the environment has last been used.
         */
        public var automaticStopTimeMinutes: kotlin.Int? = null
        /**
         * A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no more than one time.
         *
         * For more information, see [Client Tokens](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The connection type used for connecting to an Amazon EC2 environment. Valid values are `CONNECT_SSH` (default) and `CONNECT_SSM` (connected through Amazon EC2 Systems Manager).
         *
         * For more information, see [Accessing no-ingress EC2 instances with Amazon EC2 Systems Manager](https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html) in the *Cloud9 User Guide*.
         */
        public var connectionType: aws.sdk.kotlin.services.cloud9.model.ConnectionType? = null
        /**
         * The description of the environment to create.
         */
        public var description: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path.
         *
         * From December 04, 2023, you will be required to include the `imageId` parameter for the `CreateEnvironmentEC2` action. This change will be reflected across all direct methods of communicating with the API, such as Amazon Web Services SDK, Amazon Web Services CLI and Amazon Web Services CloudFormation. This change will only affect direct API consumers, and not Cloud9 console users.
         *
         * We recommend using Amazon Linux 2023 as the AMI to create your environment as it is fully supported.
         *
         * Since Ubuntu 18.04 has ended standard support as of May 31, 2023, we recommend you choose Ubuntu 22.04.
         *
         * **AMI aliases **
         * + Amazon Linux 2: `amazonlinux-2-x86_64`
         * + Amazon Linux 2023 (recommended): `amazonlinux-2023-x86_64`
         * + Ubuntu 18.04: `ubuntu-18.04-x86_64`
         * + Ubuntu 22.04: `ubuntu-22.04-x86_64`
         *
         * **SSM paths**
         * + Amazon Linux 2: `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64`
         * + Amazon Linux 2023 (recommended): `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2023-x86_64`
         * + Ubuntu 18.04: `resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64`
         * + Ubuntu 22.04: `resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64`
         */
        public var imageId: kotlin.String? = null
        /**
         * The type of instance to connect to the environment (for example, `t2.micro`).
         */
        public var instanceType: kotlin.String? = null
        /**
         * The name of the environment to create.
         *
         * This name is visible to other IAM users in the same Amazon Web Services account.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any IAM principal. If this value is not specified, the ARN defaults to this environment's creator.
         */
        public var ownerArn: kotlin.String? = null
        /**
         * The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2 instance.
         */
        public var subnetId: kotlin.String? = null
        /**
         * An array of key-value pairs that will be associated with the new Cloud9 development environment.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Request) : this() {
            this.automaticStopTimeMinutes = x.automaticStopTimeMinutes
            this.clientRequestToken = x.clientRequestToken
            this.connectionType = x.connectionType
            this.description = x.description
            this.dryRun = x.dryRun
            this.imageId = x.imageId
            this.instanceType = x.instanceType
            this.name = x.name
            this.ownerArn = x.ownerArn
            this.subnetId = x.subnetId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Request = CreateEnvironmentEc2Request(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
