// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.serde

import aws.sdk.kotlin.services.cloud9.model.Cloud9Exception
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateEnvironmentOperationDeserializer: HttpDeserialize<UpdateEnvironmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateEnvironmentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateEnvironmentError(context, call)
        }
        val builder = UpdateEnvironmentResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateEnvironmentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Cloud9Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Cloud9Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
