// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model



public class DescribeEnvironmentMembershipsRequest private constructor(builder: Builder) {
    /**
     * The ID of the environment to get environment member information about.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The maximum number of environment members to get information about.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a *next token*. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of environment member permissions to get information about. Available values include:
     * + `owner`: Owns the environment.
     * + `read-only`: Has read-only access to the environment.
     * + `read-write`: Has read-write access to the environment.
     *
     * If no value is specified, information about all environment members are returned.
     */
    public val permissions: List<Permissions>? = builder.permissions
    /**
     * The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.
     */
    public val userArn: kotlin.String? = builder.userArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEnvironmentMembershipsRequest(")
        append("environmentId=$environmentId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("permissions=$permissions,")
        append("userArn=$userArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (userArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEnvironmentMembershipsRequest

        if (environmentId != other.environmentId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (permissions != other.permissions) return false
        if (userArn != other.userArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the environment to get environment member information about.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The maximum number of environment members to get information about.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a *next token*. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The type of environment member permissions to get information about. Available values include:
         * + `owner`: Owns the environment.
         * + `read-only`: Has read-only access to the environment.
         * + `read-write`: Has read-write access to the environment.
         *
         * If no value is specified, information about all environment members are returned.
         */
        public var permissions: List<Permissions>? = null
        /**
         * The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned.
         */
        public var userArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsRequest) : this() {
            this.environmentId = x.environmentId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.permissions = x.permissions
            this.userArn = x.userArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsRequest = DescribeEnvironmentMembershipsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
