// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.serde

import aws.sdk.kotlin.services.cloud9.model.Cloud9Exception
import aws.sdk.kotlin.services.cloud9.model.EnvironmentMember
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentMembershipResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateEnvironmentMembershipOperationDeserializer: HttpDeserialize<UpdateEnvironmentMembershipResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateEnvironmentMembershipResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateEnvironmentMembershipError(context, call)
        }
        val builder = UpdateEnvironmentMembershipResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateEnvironmentMembershipOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateEnvironmentMembershipError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Cloud9Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Cloud9Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateEnvironmentMembershipOperationBody(builder: UpdateEnvironmentMembershipResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MEMBERSHIP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("membership"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEMBERSHIP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MEMBERSHIP_DESCRIPTOR.index -> builder.membership = deserializeEnvironmentMemberDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
