// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.GetMlInputChannelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.InputChannel
import aws.sdk.kotlin.services.cleanroomsml.model.MlInputChannelStatus
import aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetMLInputChannelOperationDeserializer: HttpDeserializer.NonStreaming<GetMlInputChannelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMlInputChannelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMlInputChannelError(context, call, payload)
        }
        val builder = GetMlInputChannelResponse.Builder()

        if (payload != null) {
            deserializeGetMLInputChannelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMlInputChannelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMLInputChannelOperationBody(builder: GetMlInputChannelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLLABORATIONIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("collaborationIdentifier"))
    val CONFIGUREDMODELALGORITHMASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("configuredModelAlgorithmAssociations"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INPUTCHANNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inputChannel"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val MEMBERSHIPIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("membershipIdentifier"))
    val MLINPUTCHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mlInputChannelArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val NUMBEROFFILES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("numberOfFiles"))
    val NUMBEROFRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("numberOfRecords"))
    val PROTECTEDQUERYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("protectedQueryIdentifier"))
    val RETENTIONINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("retentionInDays"))
    val SIZEINGB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("sizeInGb"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("statusDetails"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLLABORATIONIDENTIFIER_DESCRIPTOR)
        field(CONFIGUREDMODELALGORITHMASSOCIATIONS_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INPUTCHANNEL_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(MEMBERSHIPIDENTIFIER_DESCRIPTOR)
        field(MLINPUTCHANNELARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NUMBEROFFILES_DESCRIPTOR)
        field(NUMBEROFRECORDS_DESCRIPTOR)
        field(PROTECTEDQUERYIDENTIFIER_DESCRIPTOR)
        field(RETENTIONINDAYS_DESCRIPTOR)
        field(SIZEINGB_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLLABORATIONIDENTIFIER_DESCRIPTOR.index -> builder.collaborationIdentifier = deserializeString()
                CONFIGUREDMODELALGORITHMASSOCIATIONS_DESCRIPTOR.index -> builder.configuredModelAlgorithmAssociations =
                    deserializer.deserializeList(CONFIGUREDMODELALGORITHMASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.ISO_8601)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INPUTCHANNEL_DESCRIPTOR.index -> builder.inputChannel = deserializeInputChannelDocument(deserializer)
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                MEMBERSHIPIDENTIFIER_DESCRIPTOR.index -> builder.membershipIdentifier = deserializeString()
                MLINPUTCHANNELARN_DESCRIPTOR.index -> builder.mlInputChannelArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NUMBEROFFILES_DESCRIPTOR.index -> builder.numberOfFiles = deserializeDouble()
                NUMBEROFRECORDS_DESCRIPTOR.index -> builder.numberOfRecords = deserializeLong()
                PROTECTEDQUERYIDENTIFIER_DESCRIPTOR.index -> builder.protectedQueryIdentifier = deserializeString()
                RETENTIONINDAYS_DESCRIPTOR.index -> builder.retentionInDays = deserializeInt()
                SIZEINGB_DESCRIPTOR.index -> builder.sizeInGb = deserializeDouble()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MlInputChannelStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeStatusDetailsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
