// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig
import aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse
import aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetConfiguredModelAlgorithmOperationDeserializer: HttpDeserializer.NonStreaming<GetConfiguredModelAlgorithmResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetConfiguredModelAlgorithmResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetConfiguredModelAlgorithmError(context, call, payload)
        }
        val builder = GetConfiguredModelAlgorithmResponse.Builder()

        if (payload != null) {
            deserializeGetConfiguredModelAlgorithmOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetConfiguredModelAlgorithmError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetConfiguredModelAlgorithmOperationBody(builder: GetConfiguredModelAlgorithmResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGUREDMODELALGORITHMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configuredModelAlgorithmArn"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INFERENCECONTAINERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inferenceContainerConfig"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRAININGCONTAINERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("trainingContainerConfig"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGUREDMODELALGORITHMARN_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INFERENCECONTAINERCONFIG_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRAININGCONTAINERCONFIG_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGUREDMODELALGORITHMARN_DESCRIPTOR.index -> builder.configuredModelAlgorithmArn = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.ISO_8601)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INFERENCECONTAINERCONFIG_DESCRIPTOR.index -> builder.inferenceContainerConfig = deserializeInferenceContainerConfigDocument(deserializer)
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRAININGCONTAINERCONFIG_DESCRIPTOR.index -> builder.trainingContainerConfig = deserializeContainerConfigDocument(deserializer)
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
