// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse
import aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetCollaborationConfiguredModelAlgorithmAssociationOperationDeserializer: HttpDeserializer.NonStreaming<GetCollaborationConfiguredModelAlgorithmAssociationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetCollaborationConfiguredModelAlgorithmAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCollaborationConfiguredModelAlgorithmAssociationError(context, call, payload)
        }
        val builder = GetCollaborationConfiguredModelAlgorithmAssociationResponse.Builder()

        if (payload != null) {
            deserializeGetCollaborationConfiguredModelAlgorithmAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetCollaborationConfiguredModelAlgorithmAssociationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCollaborationConfiguredModelAlgorithmAssociationOperationBody(builder: GetCollaborationConfiguredModelAlgorithmAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLLABORATIONIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("collaborationIdentifier"))
    val CONFIGUREDMODELALGORITHMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configuredModelAlgorithmArn"))
    val CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configuredModelAlgorithmAssociationArn"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val CREATORACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("creatorAccountId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val MEMBERSHIPIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("membershipIdentifier"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PRIVACYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("privacyConfiguration"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLLABORATIONIDENTIFIER_DESCRIPTOR)
        field(CONFIGUREDMODELALGORITHMARN_DESCRIPTOR)
        field(CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(CREATORACCOUNTID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(MEMBERSHIPIDENTIFIER_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRIVACYCONFIGURATION_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLLABORATIONIDENTIFIER_DESCRIPTOR.index -> builder.collaborationIdentifier = deserializeString()
                CONFIGUREDMODELALGORITHMARN_DESCRIPTOR.index -> builder.configuredModelAlgorithmArn = deserializeString()
                CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR.index -> builder.configuredModelAlgorithmAssociationArn = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.ISO_8601)
                CREATORACCOUNTID_DESCRIPTOR.index -> builder.creatorAccountId = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                MEMBERSHIPIDENTIFIER_DESCRIPTOR.index -> builder.membershipIdentifier = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PRIVACYCONFIGURATION_DESCRIPTOR.index -> builder.privacyConfiguration = deserializePrivacyConfigurationDocument(deserializer)
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
