// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides configuration information for the inference container.
 */
public class InferenceContainerConfig private constructor(builder: Builder) {
    /**
     * The registry path of the docker image that contains the inference algorithm. Clean Rooms ML supports both `registry/repository[:tag]` and `registry/repositry[@digest]` image path formats. For more information about using images in Clean Rooms ML, see the [Sagemaker API reference](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage).
     */
    public val imageUri: kotlin.String = requireNotNull(builder.imageUri) { "A non-null value must be provided for imageUri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceContainerConfig(")
        append("imageUri=$imageUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageUri.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceContainerConfig

        if (imageUri != other.imageUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The registry path of the docker image that contains the inference algorithm. Clean Rooms ML supports both `registry/repository[:tag]` and `registry/repositry[@digest]` image path formats. For more information about using images in Clean Rooms ML, see the [Sagemaker API reference](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage).
         */
        public var imageUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig) : this() {
            this.imageUri = x.imageUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig = InferenceContainerConfig(this)

        internal fun correctErrors(): Builder {
            if (imageUri == null) imageUri = ""
            return this
        }
    }
}
