// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the Glue data source that contains the training data.
 */
public class GlueDataSource private constructor(builder: Builder) {
    /**
     * The Glue catalog that contains the training data.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * The Glue database that contains the training data.
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * The Glue table that contains the training data.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GlueDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlueDataSource(")
        append("catalogId=$catalogId,")
        append("databaseName=$databaseName,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (databaseName.hashCode())
        result = 31 * result + (tableName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlueDataSource

        if (catalogId != other.catalogId) return false
        if (databaseName != other.databaseName) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GlueDataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Glue catalog that contains the training data.
         */
        public var catalogId: kotlin.String? = null
        /**
         * The Glue database that contains the training data.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The Glue table that contains the training data.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GlueDataSource) : this() {
            this.catalogId = x.catalogId
            this.databaseName = x.databaseName
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GlueDataSource = GlueDataSource(this)

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            if (tableName == null) tableName = ""
            return this
        }
    }
}
